/*
 * Decompiled with CFR 0.152.
 */
package tstuder.java.lib.component.table;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import tstuder.java.lib.graphics.StringFormatter;

public class ColumnDefinition {
    public static final int WIDTH_FIXED_N_PIXELS = 0;
    public static final int WIDTH_FIXED_N_CHARS = 1;
    public static final int WIDTH_AUTO_BY_TITLE = 2;
    public static final int WIDTH_AUTO = 3;
    private int widthInChars = 10;
    private int widthInPixels = 60;
    private int widthAdjustment = 2;
    private Color titleBackground;
    private Color titleForeground;
    private Color dataBackground;
    private Color dataForeground;
    private String title;
    private Font titleFont;
    private Font dataFont;
    private FontMetrics titleFontMetrics;
    private FontMetrics dataFontMetrics;
    private boolean wrapDataCells;
    private StringFormatter titleFormatter;
    private StringFormatter dataFormatter;

    public ColumnDefinition(String string) {
        this(string, 2, null, null);
    }

    public ColumnDefinition(String string, int n, StringFormatter stringFormatter, StringFormatter stringFormatter2) {
        this.setTitleFormatter(stringFormatter);
        this.setDataFormatter(stringFormatter2);
        this.title = string;
        this.widthAdjustment = n;
    }

    public ColumnDefinition(String string, StringFormatter stringFormatter, StringFormatter stringFormatter2) {
        this(string, 2, stringFormatter, stringFormatter2);
    }

    public Color getDataBackground() {
        return this.dataBackground;
    }

    public Font getDataFont() {
        return this.dataFont;
    }

    public FontMetrics getDataFontMetrics() {
        return this.dataFontMetrics;
    }

    public Color getDataForeground() {
        return this.dataForeground;
    }

    public StringFormatter getDataFormatter() {
        return this.dataFormatter;
    }

    public int getPreferredDataLineHeight(FontMetrics fontMetrics) {
        FontMetrics fontMetrics2 = this.dataFontMetrics == null ? fontMetrics : this.dataFontMetrics;
        return fontMetrics2.getHeight();
    }

    public int getPreferredTitleHeight(FontMetrics fontMetrics, StringFormatter stringFormatter) {
        return this.getPreferredTitleHeight(fontMetrics, stringFormatter, -1);
    }

    public int getPreferredTitleHeight(FontMetrics fontMetrics, StringFormatter stringFormatter, int n) {
        StringFormatter stringFormatter2 = this.titleFormatter == null ? stringFormatter : this.titleFormatter;
        FontMetrics fontMetrics2 = this.titleFontMetrics == null ? fontMetrics : this.titleFontMetrics;
        int n2 = n > 0 ? n : Short.MAX_VALUE;
        stringFormatter2.measureString(fontMetrics2, this.title, 0, 0, n2, Short.MAX_VALUE);
        return stringFormatter2.getPreferredHeight();
    }

    public int getPreferredWidth(FontMetrics fontMetrics, StringFormatter stringFormatter) {
        switch (this.widthAdjustment) {
            case 0: {
                return this.widthInPixels;
            }
            case 1: {
                FontMetrics fontMetrics2 = this.dataFontMetrics == null ? fontMetrics : this.dataFontMetrics;
                return this.widthInChars * fontMetrics2.charWidth('0');
            }
        }
        FontMetrics fontMetrics3 = this.titleFontMetrics == null ? fontMetrics : this.titleFontMetrics;
        StringFormatter stringFormatter2 = this.titleFormatter == null ? stringFormatter : this.titleFormatter;
        stringFormatter2.measureString(fontMetrics3, this.title, 0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        return stringFormatter2.getPreferredWidth();
    }

    public String getTitle() {
        return this.title;
    }

    public Color getTitleBackground() {
        return this.titleBackground;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public FontMetrics getTitleFontMetrics() {
        return this.titleFontMetrics;
    }

    public Color getTitleForeground() {
        return this.titleForeground;
    }

    public StringFormatter getTitleFormatter() {
        return this.titleFormatter;
    }

    public int getWidthAdjustment() {
        return this.widthAdjustment;
    }

    public int getWidthInChars() throws IllegalArgumentException {
        if (this.widthAdjustment != 1) {
            throw new IllegalArgumentException();
        }
        return this.widthInChars;
    }

    public int getWidthInPixels() throws IllegalArgumentException {
        if (this.widthAdjustment != 0) {
            throw new IllegalArgumentException();
        }
        return this.widthInPixels;
    }

    boolean getWrapDataCells() {
        return this.wrapDataCells;
    }

    public void setDataBackground(Color color) {
        this.dataBackground = color;
    }

    public void setDataFont(Font font) {
        this.dataFont = font;
        this.dataFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public void setDataForeground(Color color) {
        this.dataForeground = color;
    }

    public void setDataFormatter(StringFormatter stringFormatter) {
        this.dataFormatter = stringFormatter;
        this.wrapDataCells = this.dataFormatter != null && this.dataFormatter.isWrappingFormatter();
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setTitleBackground(Color color) {
        this.titleBackground = color;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
        this.titleFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public void setTitleForeground(Color color) {
        this.titleForeground = color;
    }

    public void setTitleFormatter(StringFormatter stringFormatter) {
        this.titleFormatter = stringFormatter;
    }

    public void setWidthAdjustment(int n) {
        this.widthAdjustment = n;
    }

    public void setWidthInChars(int n) {
        this.widthAdjustment = 1;
        this.widthInChars = n;
    }

    public void setWidthInPixels(int n) {
        this.widthAdjustment = 0;
        this.widthInPixels = n;
    }
}

