/*
 * Decompiled with CFR 0.152.
 */
package tstuder.java.lib.component.table;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.BitSet;
import java.util.Vector;
import tstuder.java.lib.component.table.ColumnDefinition;
import tstuder.java.lib.component.table.Table;
import tstuder.java.lib.component.table.TableRow;
import tstuder.java.lib.graphics.Border;
import tstuder.java.lib.graphics.BorderRaised;
import tstuder.java.lib.graphics.CheckMark;
import tstuder.java.lib.graphics.StringFormatter;
import tstuder.java.lib.util.DragScroller;
import tstuder.java.lib.util.SwapListener;
import tstuder.java.lib.util.Util;

public class DataArea
extends Component
implements MouseListener,
KeyListener,
MouseMotionListener,
AdjustmentListener,
FocusListener,
SwapListener {
    private static StringFormatter defaultFormatter = new StringFormatter();
    private static StringFormatter lineNumberFormatter = new StringFormatter(8, 4);
    private static Color gridLinesColor = Color.lightGray;
    private static int checkMarkColumnWidth = 22;
    private static int lineNumberColumnWidth = 30;
    private static Color referenceColumnForeground = Color.black;
    private static Color referenceColumnBackground = Color.lightGray;
    private static Border referenceColumnBorder;
    private static Font referenceColumnFont;
    public static final int SELECT_ZERO_OR_ONE = 0;
    public static final int SELECT_ONE = 1;
    public static final int SELECT_MANY = 2;
    public static final int SELECT_MANY_CONTINUOUS = 3;
    private Table parentTable;
    private Vector columns;
    private Vector rows;
    private int[] columnWidths;
    private boolean showGrid = true;
    private int currentFocus = 0;
    private int currentSelection = -1;
    private int selectionCount = 0;
    private int lineHeight = 1;
    private int hScrollPos = 0;
    private int vScrollPos = 0;
    private boolean scrollingOptimization;
    private boolean checkingSelects = false;
    private Color[] selectionBackground;
    private Color[] selectionForeground;
    private boolean showLineNumbers = false;
    private boolean showCheckmarks = false;
    private int referenceColumnWidth;
    private double lineHeightFactor = 1.0;
    private int preferredHeight = -1;
    private boolean hasFocus;
    private CheckMark checkMark;
    public final int DEFAULT_BUF_SIZE = 80;
    private char[] charBuf = new char[80];
    private int charBufResetCounter = 0;
    private Image offScreen;
    private Graphics offScreenGraphics;
    private BitSet selections = new BitSet();
    private int selectionMode = 2;
    private BitSet checkmarks = new BitSet();
    private Scrollbar vScrollbar;
    private Scrollbar hScrollbar;
    private ActionListener actionListener;
    private ItemListener itemListener;
    private AdjustmentListener adjustmentListener;
    private PopupMenu popup;
    private Color fg;
    private Color bg;
    private Font f;
    private FontMetrics fm;
    private int w;
    private int h;
    private int lastDragLine;
    private DragScroller scroller;

    static {
        DataArea.setReferenceColumnBorder(new BorderRaised());
        DataArea.setReferenceColumnFont(new Font("SansSerif", 0, 10));
    }

    public DataArea(Table table, Scrollbar scrollbar, Scrollbar scrollbar2, Vector vector, Vector vector2) {
        this.parentTable = table;
        this.setScrollbars(scrollbar, scrollbar2);
        this.columns = vector;
        this.rows = vector2;
        this.initialize();
    }

    int actualColumnWidth(int n) {
        return n + 4 + 4;
    }

    public void add(PopupMenu popupMenu) {
        this.popup = popupMenu;
        super.add(popupMenu);
    }

    void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, adjustmentListener);
    }

    void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Vector vector = this.rows;
        synchronized (vector) {
            Object object;
            int n;
            if (this.scrollingOptimization) {
                n = adjustmentEvent.getValue();
                object = Toolkit.getDefaultToolkit().getSystemEventQueue();
                AWTEvent aWTEvent = ((EventQueue)object).peekEvent();
                while (aWTEvent != null && aWTEvent instanceof AdjustmentEvent) {
                    try {
                        n = ((AdjustmentEvent)((EventQueue)object).getNextEvent()).getValue();
                    }
                    catch (InterruptedException interruptedException) {}
                    aWTEvent = ((EventQueue)object).peekEvent();
                }
            } else {
                n = adjustmentEvent.getValue();
            }
            this.fireAdjustmentEvent(new AdjustmentEvent((Adjustable)adjustmentEvent.getSource(), adjustmentEvent.getID(), adjustmentEvent.getAdjustmentType(), n));
            object = (Scrollbar)adjustmentEvent.getSource();
            if (object == this.vScrollbar) {
                this.scrollTo(-n);
            } else if (object == this.hScrollbar) {
                this.setHorizontalScrollPos(-n);
                this.paint(this.getGraphics());
            }
        }
    }

    void check(int n) {
        this.check(n, true);
    }

    void check(int n, boolean bl) {
        if (this.checkmarks.get(n) != bl) {
            if (bl) {
                this.checkmarks.set(n);
            } else {
                this.checkmarks.clear(n);
            }
            if (n >= -this.vScrollPos && n <= -this.vScrollPos + this.getVisibleCount()) {
                this.paintLine(n);
            }
        }
    }

    void checkAll() {
        int n = 0;
        while (n < this.rows.size()) {
            this.check(n, true);
            ++n;
        }
    }

    private void clickLine(int n, boolean bl, boolean bl2, boolean bl3) {
        if (n < 0 || n >= this.rows.size()) {
            return;
        }
        switch (this.selectionMode) {
            case 1: {
                this.clickLineOne(n, bl, bl2, bl3);
                break;
            }
            case 0: {
                this.clickLineZeroOrOne(n, bl, bl2, bl3);
                break;
            }
            case 2: {
                this.clickLineMany(n, bl, bl2, bl3);
                break;
            }
            case 3: {
                this.clickLineManyContinuous(n, bl, bl2, bl3);
            }
        }
    }

    private void clickLineMany(int n, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            int n2;
            if (bl) {
                int n3 = this.currentSelection;
                if (n3 < 0) {
                    n3 = this.currentFocus;
                }
                if (n3 < 0) {
                    n3 = 0;
                }
                this.currentSelection = n3;
                this.moveFocus(n, true, false);
                this.selectRange(n3, n);
                n2 = 1;
            } else {
                this.moveFocus(n, true, false);
                if (!this.isSelected(n)) {
                    this.currentSelection = n;
                    this.select(n, true);
                    n2 = 1;
                } else {
                    this.select(n, false);
                    n2 = 2;
                }
            }
            this.fireItemEvent(new ItemEvent(this.parentTable, 701, this.rows.elementAt(n), n2));
        } else {
            this.clickLineManyContinuous(n, bl, bl2, bl3);
        }
    }

    private void clickLineManyContinuous(int n, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            int n2 = this.currentSelection;
            if (n2 < 0) {
                n2 = this.currentFocus;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            this.moveFocus(n, true, true);
            this.selectRangeExclusive(n2, n);
            this.currentSelection = n2;
            this.fireItemEvent(new ItemEvent(this.parentTable, 701, this.rows.elementAt(n), 1));
        } else {
            if (this.selectionCount > 1) {
                this.deselectAll(true);
            }
            this.clickLineZeroOrOne(n, bl, bl2, bl3);
        }
    }

    private void clickLineOne(int n, boolean bl, boolean bl2, boolean bl3) {
        if (!this.isSelected(n)) {
            this.clickLineZeroOrOne(n, false, false, bl3);
        }
    }

    private void clickLineZeroOrOne(int n, boolean bl, boolean bl2, boolean bl3) {
        if (this.isSelected(n)) {
            if (bl2) {
                this.moveFocus(n, true, false);
                if (this.currentSelection == n) {
                    this.currentSelection = -1;
                }
                --this.selectionCount;
                this.selections.clear(n);
                if (bl3) {
                    this.paintLine(n);
                }
                this.fireItemEvent(new ItemEvent(this.parentTable, 701, this.rows.elementAt(n), 2));
            } else {
                this.moveFocus(n, true, bl3);
                this.currentSelection = n;
            }
        } else {
            this.moveFocus(n, true, false);
            if (this.currentSelection >= 0) {
                this.deselect(this.currentSelection);
            }
            this.selections.set(n);
            this.currentSelection = n;
            ++this.selectionCount;
            if (bl3) {
                this.paintLine(n);
            }
            this.fireItemEvent(new ItemEvent(this.parentTable, 701, this.rows.elementAt(n), 1));
        }
    }

    void deselect(int n) {
        this.select(n, false);
    }

    void deselectAll(boolean bl) {
        if (bl) {
            int n = -this.vScrollPos;
            int n2 = n + this.getVisibleCount();
            int n3 = n;
            while (n3 < n2) {
                if (this.selections.get(n3)) {
                    this.selections.clear(n3);
                    this.paintLine(n3);
                }
                ++n3;
            }
        }
        this.selections = new BitSet();
        this.selectionCount = 0;
        this.currentSelection = -1;
    }

    private void eraseBottom(Graphics graphics, int n) {
        if (n < this.h) {
            graphics.setColor(this.bg);
            graphics.fillRect(0, n, this.w, this.h - n);
            graphics.drawLine(0, n, this.w, this.h);
        }
    }

    public void finalize() throws Throwable {
        this.flush();
        super.finalize();
    }

    private int findLine(int n) {
        int n2 = n / this.lineHeight - this.vScrollPos;
        if (n2 < 0 || n2 >= this.rows.size()) {
            return -1;
        }
        return n2;
    }

    void fireActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    void fireAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        if (this.adjustmentListener != null) {
            this.adjustmentListener.adjustmentValueChanged(adjustmentEvent);
        }
    }

    void fireItemEvent(ItemEvent itemEvent) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(itemEvent);
        }
    }

    private void flush() {
        if (this.offScreen != null) {
            this.offScreen.flush();
            this.offScreen = null;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.offScreenGraphics == null) {
            return;
        }
        Vector vector = this.rows;
        synchronized (vector) {
            if (!this.hasFocus) {
                this.hasFocus = true;
                if (this.rows.size() > 0) {
                    this.paintLine(this.currentFocus);
                }
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.offScreenGraphics == null || this.getGraphics() == null) {
            return;
        }
        Vector vector = this.rows;
        synchronized (vector) {
            if (this.hasFocus) {
                this.hasFocus = false;
                if (this.rows.size() > 0) {
                    this.paintLine(this.currentFocus);
                }
            }
        }
    }

    int[] getCheckedIndexes() {
        if (!this.showCheckmarks) {
            return null;
        }
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        while (n < this.rows.size()) {
            if (this.checkmarks.get(n)) {
                vector.addElement(new Integer(n));
            }
            ++n;
        }
        int[] nArray = new int[vector.size()];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = (Integer)vector.elementAt(n2);
            ++n2;
        }
        return nArray;
    }

    public boolean getCheckingSelects() {
        return this.checkingSelects;
    }

    int[] getColumnWidths() {
        return this.columnWidths;
    }

    int getCompletelyVisibleCount() {
        return this.h / this.lineHeight;
    }

    public static StringFormatter getDefaultFormatter() {
        return defaultFormatter;
    }

    public static Color getGridLinesColor() {
        return gridLinesColor;
    }

    boolean getHasFillerLine() {
        return this.rows.size() * this.lineHeight > this.h && this.h % this.lineHeight != 0;
    }

    int getHorizontalScrollPos() {
        return this.hScrollPos;
    }

    public static StringFormatter getLineNumberFormatter() {
        return lineNumberFormatter;
    }

    public Dimension getMinimumSize() {
        if (this.columns == null) {
            return new Dimension(10, 10);
        }
        int n = 0;
        this.lineHeight = 0;
        if (this.columnWidths == null) {
            this.setDefaultWidths();
        }
        int n2 = 0;
        while (n2 < this.columnWidths.length) {
            n += this.columnWidths[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < this.columns.size()) {
            int n3 = ((ColumnDefinition)this.columns.elementAt(n2)).getPreferredDataLineHeight(this.getFontMetrics(this.getFont()));
            if (n3 > this.lineHeight) {
                this.lineHeight = n3;
            }
            ++n2;
        }
        this.lineHeight = (int)((double)this.lineHeight * this.lineHeightFactor);
        this.lineHeight += 2;
        return new Dimension(n + this.getReferenceColumnWidth(), this.lineHeight);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.height = this.preferredHeight == -1 ? this.rows.size() * dimension.height : this.preferredHeight * dimension.height;
        return dimension;
    }

    public static Color getReferenceColumnBackground() {
        return referenceColumnBackground;
    }

    public static Border getReferenceColumnBorder() {
        return referenceColumnBorder;
    }

    public static Font getReferenceColumnFont() {
        return referenceColumnFont;
    }

    public static Color getReferenceColumnForeground() {
        return referenceColumnForeground;
    }

    int getReferenceColumnWidth() {
        int n = 0;
        if (this.showLineNumbers) {
            n += lineNumberColumnWidth;
        }
        if (this.showCheckmarks) {
            n += checkMarkColumnWidth;
        }
        return n;
    }

    int getSelectedIndex() {
        if (this.selectionCount == 1 && this.currentSelection >= 0) {
            return this.currentSelection;
        }
        return -1;
    }

    int[] getSelectedIndexes() {
        int[] nArray = new int[this.selectionCount];
        int n = 0;
        int n2 = 0;
        while (n < this.rows.size()) {
            if (this.selections.get(n)) {
                nArray[n2++] = n;
            }
            ++n;
        }
        return nArray;
    }

    public Object[] getSelectedObjects() {
        Vector vector = this.rows;
        synchronized (vector) {
            int[] nArray = this.getSelectedIndexes();
            Object[] objectArray = new Object[nArray.length];
            int n = 0;
            while (n < nArray.length) {
                objectArray[n] = this.rows.elementAt(nArray[n]);
                ++n;
            }
            return objectArray;
        }
    }

    int getSelectionMode() {
        return this.selectionMode;
    }

    boolean getShowCheckmarks() {
        return this.showCheckmarks;
    }

    boolean getShowGrid() {
        return this.showGrid;
    }

    boolean getShowLineNumbers() {
        return this.showLineNumbers;
    }

    int getVerticalScrollPos() {
        return this.vScrollPos;
    }

    int getVisibleCount() {
        int n = this.h / this.lineHeight;
        if (n >= this.rows.size()) {
            return this.rows.size();
        }
        if (this.h % this.lineHeight != 0) {
            return n + 1;
        }
        return n;
    }

    private void initialize() {
        Object object;
        try {
            object = System.getSecurityManager();
            if (object != null) {
                object.checkAwtEventQueueAccess();
            }
            this.scrollingOptimization = true;
        }
        catch (Exception exception) {
            this.scrollingOptimization = false;
        }
        if (this.columns == null) {
            this.selectionBackground = new Color[0];
            this.selectionForeground = new Color[0];
        } else {
            this.selectionBackground = new Color[this.columns.size()];
            this.selectionForeground = new Color[this.columns.size()];
        }
        object = new Color(0, 0, 128);
        Color color = Color.white;
        int n = 0;
        while (n < this.selectionBackground.length) {
            this.selectionBackground[n] = object;
            this.selectionForeground[n] = color;
            ++n;
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(this);
        this.addKeyListener(this);
    }

    final boolean isChecked(int n) {
        return this.checkmarks.get(n);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    final boolean isSelected(int n) {
        return this.selections.get(n);
    }

    private void keyDown(KeyEvent keyEvent) {
        keyEvent.getKeyCode();
        int n = 0;
        if (!(this.isSelected(this.currentFocus) || keyEvent.isShiftDown() || keyEvent.isControlDown())) {
            this.clickLine(this.currentFocus, keyEvent.isShiftDown(), keyEvent.isControlDown(), true);
        } else {
            int n2;
            n = Math.min(this.rows.size() - 1, this.currentFocus + 1);
            if (n >= (n2 = -this.vScrollPos + this.getCompletelyVisibleCount())) {
                if (keyEvent.isControlDown() && !keyEvent.isShiftDown()) {
                    this.moveFocus(n, true, false);
                } else {
                    this.clickLine(n, keyEvent.isShiftDown(), keyEvent.isControlDown(), false);
                }
                this.scrollTo(this.vScrollPos - 1);
                if (this.vScrollbar != null) {
                    this.vScrollbar.setValue(-(this.vScrollPos - 1));
                }
            } else if (keyEvent.isControlDown() && !keyEvent.isShiftDown()) {
                this.moveFocus(n, true, true);
            } else {
                this.clickLine(n, keyEvent.isShiftDown(), keyEvent.isControlDown(), true);
            }
        }
    }

    private void keyPageDown(KeyEvent keyEvent) {
        int n = this.getCompletelyVisibleCount();
        if (n > this.rows.size()) {
            n = this.rows.size();
        }
        if (this.currentFocus < -this.vScrollPos + n - 1) {
            if (!keyEvent.isShiftDown()) {
                this.moveFocus(-this.vScrollPos + n - 1, true, true);
            } else {
                this.clickLine(-this.vScrollPos + n - 1, keyEvent.isShiftDown(), keyEvent.isControlDown(), true);
            }
        } else {
            int n2 = this.vScrollPos - n;
            if (n2 < -this.rows.size() + n) {
                n2 = -this.rows.size() + n;
            }
            if (!keyEvent.isShiftDown()) {
                this.moveFocus(Math.min(-n2 + n - 1, this.rows.size() - 1), true, false);
                this.scrollTo(n2);
                if (this.vScrollbar != null) {
                    this.vScrollbar.setValue(-n2);
                }
            } else {
                this.clickLine(Math.min(-n2 + n - 1, this.rows.size() - 1), keyEvent.isShiftDown(), keyEvent.isControlDown(), true);
                this.scrollTo(n2);
                if (this.vScrollbar != null) {
                    this.vScrollbar.setValue(-n2);
                }
            }
        }
    }

    private void keyPageUp(KeyEvent keyEvent) {
        if (this.currentFocus > -this.vScrollPos) {
            if (!keyEvent.isShiftDown()) {
                this.moveFocus(-this.vScrollPos, true, true);
            } else {
                this.clickLine(-this.vScrollPos, keyEvent.isShiftDown(), keyEvent.isControlDown(), true);
            }
        } else {
            int n = Math.min(this.vScrollPos + this.getCompletelyVisibleCount(), 0);
            if (!keyEvent.isShiftDown()) {
                this.moveFocus(-n, true, false);
                this.scrollTo(n);
                if (this.vScrollbar != null) {
                    this.vScrollbar.setValue(-n);
                }
            } else {
                this.clickLine(-n, keyEvent.isShiftDown(), keyEvent.isControlDown(), true);
                this.scrollTo(n);
                if (this.vScrollbar != null) {
                    this.vScrollbar.setValue(-n);
                }
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 32: {
                Vector vector = this.rows;
                synchronized (vector) {
                    if (this.showCheckmarks) {
                        this.check(this.currentFocus, !this.isChecked(this.currentFocus));
                    }
                    this.clickLine(this.currentFocus, keyEvent.isShiftDown(), keyEvent.isControlDown(), true);
                    break;
                }
            }
            case 10: {
                this.fireActionEvent(new ActionEvent(this.parentTable, 1001, null));
                break;
            }
            case 40: {
                Vector vector = this.rows;
                synchronized (vector) {
                    this.keyDown(keyEvent);
                    break;
                }
            }
            case 38: {
                Vector vector = this.rows;
                synchronized (vector) {
                    this.keyUp(keyEvent);
                    break;
                }
            }
            case 34: {
                Vector vector = this.rows;
                synchronized (vector) {
                    this.keyPageDown(keyEvent);
                    break;
                }
            }
            case 33: {
                Vector vector = this.rows;
                synchronized (vector) {
                    this.keyPageUp(keyEvent);
                    break;
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void keyUp(KeyEvent keyEvent) {
        int n;
        keyEvent.getKeyCode();
        int n2 = 0;
        if (!(this.isSelected(this.currentFocus) || keyEvent.isShiftDown() || keyEvent.isControlDown())) {
            this.clickLine(this.currentFocus, keyEvent.isShiftDown(), keyEvent.isControlDown(), true);
            return;
        }
        n2 = Math.max(0, this.currentFocus - 1);
        if (n2 < (n = -this.vScrollPos)) {
            if (keyEvent.isControlDown() && !keyEvent.isShiftDown()) {
                this.moveFocus(n2, true, false);
            } else {
                this.clickLine(n2, keyEvent.isShiftDown(), keyEvent.isControlDown(), false);
            }
            this.scrollTo(this.vScrollPos + 1);
            if (this.vScrollbar != null) {
                this.vScrollbar.setValue(-(this.vScrollPos + 1));
            }
        } else if (keyEvent.isControlDown() && !keyEvent.isShiftDown()) {
            this.moveFocus(n2, true, true);
        } else {
            this.clickLine(n2, keyEvent.isShiftDown(), keyEvent.isControlDown(), true);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Cloneable cloneable;
        if (!this.isEnabled()) {
            return;
        }
        int n = mouseEvent.getY();
        int n2 = this.getReferenceColumnWidth();
        if (this.scroller == null) {
            cloneable = new Rectangle(n2, 0, this.w - n2, this.getCompletelyVisibleCount() * this.lineHeight);
            this.scroller = new DragScroller((Rectangle)cloneable, this, this);
        }
        this.scroller.drag(mouseEvent.getX(), n, mouseEvent.getModifiers() | 1);
        if (mouseEvent.getX() > n2 && n >= 0 && n <= this.getCompletelyVisibleCount() * this.lineHeight) {
            cloneable = this.rows;
            synchronized (cloneable) {
                int n3 = this.findLine(mouseEvent.getY());
                if (n3 >= 0 && n3 != this.lastDragLine) {
                    this.clickLine(n3, true, mouseEvent.isControlDown(), true);
                    this.lastDragLine = n3;
                }
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.requestFocus();
        Vector vector = this.rows;
        synchronized (vector) {
            int n = this.findLine(mouseEvent.getY());
            if (n == -1) {
                return;
            }
            if (this.showCheckmarks && mouseEvent.getX() <= this.getReferenceColumnWidth()) {
                this.check(n, !this.isChecked(n));
                if (this.checkingSelects) {
                    this.lastDragLine = n;
                    this.clickLine(n, mouseEvent.isShiftDown(), mouseEvent.isControlDown(), true);
                } else {
                    this.moveFocus(n, true, true);
                }
                return;
            }
            this.lastDragLine = n;
            this.clickLine(n, mouseEvent.isShiftDown(), mouseEvent.isControlDown(), true);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.scroller != null) {
            this.scroller = null;
        }
        if (mouseEvent.getClickCount() == 2) {
            this.fireActionEvent(new ActionEvent(this.parentTable, 1001, null));
        }
    }

    public void moveFocus(int n) {
        this.moveFocus(n, true, true);
    }

    private void moveFocus(int n, boolean bl, boolean bl2) {
        if (this.currentFocus != n) {
            int n2 = this.currentFocus;
            this.currentFocus = n;
            if (bl) {
                this.paintLine(n2);
            }
            if (bl2) {
                this.paintLine(n);
            }
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.w = dimension.width;
        this.h = dimension.height;
        this.prepareOffScreen(graphics);
        this.referenceColumnWidth = this.getReferenceColumnWidth();
        this.bg = this.getBackground();
        this.fg = this.getForeground();
        this.f = this.getFont();
        this.fm = this.getFontMetrics(this.f);
        if (this.showCheckmarks && this.checkMark == null) {
            this.checkMark = new CheckMark(this, true);
        }
        Vector vector = this.rows;
        synchronized (vector) {
            this.updateVerticalScrollbar();
            this.updateHorizontalScrollbar();
            this.paintVisibleRows(graphics);
        }
        if (this.charBufResetCounter % 4096 == 0) {
            this.charBuf = new char[80];
            this.charBufResetCounter = 0;
        } else {
            ++this.charBufResetCounter;
        }
    }

    private void paintFocus(Graphics graphics, int n) {
        if (!this.isEnabled()) {
            return;
        }
        int n2 = this.getReferenceColumnWidth();
        int n3 = this.lineHeight - 1 - (this.showGrid ? 1 : 0);
        --n;
        graphics.setColor(Color.white);
        graphics.setXORMode(Color.black);
        int n4 = n2;
        while (n4 < n) {
            graphics.drawLine(n4, 0, n4, 0);
            n4 += 2;
        }
        n4 = n2;
        while (n4 < n) {
            graphics.drawLine(n4, n3, n4, n3);
            n4 += 2;
        }
        n4 = 1;
        while (n4 < n3) {
            graphics.drawLine(n2, n4, n2, n4);
            n4 += 2;
        }
        n4 = 1;
        while (n4 < n3) {
            graphics.drawLine(n, n4, n, n4);
            n4 += 2;
        }
        graphics.setPaintMode();
    }

    private void paintLine(int n) {
        this.paintLine(this.getGraphics(), n, 0, this.columns.size());
    }

    private void paintLine(Graphics graphics, int n, int n2, int n3) {
        String string;
        Color[] colorArray;
        Color[] colorArray2;
        Graphics graphics2 = this.offScreenGraphics;
        Shape shape = graphics2.getClip();
        int n4 = 0;
        boolean bl = this.isSelected(n);
        TableRow tableRow = null;
        tableRow = (TableRow)this.rows.elementAt(n);
        String[] stringArray = tableRow.getStrings();
        if (bl && this.isEnabled()) {
            colorArray2 = this.selectionBackground;
            colorArray = this.selectionForeground;
        } else {
            colorArray2 = tableRow.getBackgrounds();
            colorArray = tableRow.getForegrounds();
        }
        if (n2 == 0) {
            Insets insets = referenceColumnBorder.getInsets();
            graphics2.setColor(referenceColumnBackground);
            graphics2.fillRect(0, 0, this.referenceColumnWidth, this.lineHeight);
            graphics2.setColor(referenceColumnForeground);
            graphics2.setFont(referenceColumnFont);
            if (this.showLineNumbers) {
                string = String.valueOf(n + 1);
                string.getChars(0, string.length(), this.charBuf, 0);
                lineNumberFormatter.formatString(graphics2, graphics2.getFontMetrics(referenceColumnFont), String.valueOf(n + 1), insets.left, insets.top, lineNumberColumnWidth - insets.right - insets.left - 4, this.lineHeight - insets.top - insets.bottom);
                n4 = lineNumberColumnWidth;
            }
            if (this.showCheckmarks) {
                this.checkMark.paint(graphics2, this.isChecked(n), n4, 0, checkMarkColumnWidth, this.lineHeight);
                n4 += checkMarkColumnWidth;
            }
            referenceColumnBorder.paint(graphics2, 0, 0, this.referenceColumnWidth, this.lineHeight);
            graphics2.clipRect(n4, 0, this.w - n4, this.lineHeight);
        }
        n4 += this.hScrollPos;
        int n5 = n2;
        while (n5 < n3) {
            FontMetrics fontMetrics;
            Font font;
            Object object;
            ColumnDefinition columnDefinition = (ColumnDefinition)this.columns.elementAt(n5);
            int n6 = this.columnWidths[n5];
            if (colorArray2 != null) {
                graphics2.setColor(colorArray2[n5]);
            } else {
                object = columnDefinition.getDataBackground();
                if (object == null) {
                    graphics2.setColor(this.bg);
                } else {
                    graphics2.setColor((Color)object);
                }
            }
            graphics2.fillRect(n4, 0, n6, this.lineHeight);
            if (colorArray != null) {
                graphics2.setColor(colorArray[n5]);
            } else {
                object = columnDefinition.getDataForeground();
                if (object == null) {
                    graphics2.setColor(this.fg);
                } else {
                    graphics2.setColor((Color)object);
                }
            }
            object = columnDefinition.getDataFormatter();
            if (object == null) {
                object = defaultFormatter;
            }
            if ((font = columnDefinition.getDataFont()) == null) {
                graphics2.setFont(this.f);
                fontMetrics = this.fm;
            } else {
                graphics2.setFont(font);
                fontMetrics = columnDefinition.getDataFontMetrics();
            }
            string = stringArray[n5];
            if (columnDefinition.getWrapDataCells()) {
                ((StringFormatter)object).formatString(graphics2, fontMetrics, string, n4 + 4, 1, n6 - 4 - 4, this.lineHeight - 1 - 1);
            } else {
                if (string.length() > this.charBuf.length) {
                    this.charBuf = new char[string.length()];
                }
                string.getChars(0, string.length(), this.charBuf, 0);
                ((StringFormatter)object).drawChars(graphics2, fontMetrics, this.charBuf, 0, string.length(), n4 + 4, 1 + ((StringFormatter)object).calcBaselineOffset(fontMetrics, this.lineHeight - 1 - 1), n6 - 4 - 4);
            }
            n4 += n6;
            if (this.showGrid) {
                graphics2.setColor(gridLinesColor);
                graphics2.drawLine(n4 - 1, 0, n4 - 1, this.lineHeight - 1);
            }
            ++n5;
        }
        if (n4 < this.w) {
            graphics2.setColor(this.bg);
            graphics2.fillRect(n4, 0, this.w - n4, this.lineHeight);
        }
        graphics2.setClip(shape);
        if (this.showGrid) {
            graphics2.setColor(gridLinesColor);
            graphics2.drawLine(this.referenceColumnWidth, this.lineHeight - 1, n4 - 1, this.lineHeight - 1);
        }
        if (this.hasFocus && n == this.currentFocus) {
            this.paintFocus(graphics2, Math.min(this.w, n4));
        }
        n5 = (this.vScrollPos + n) * this.lineHeight;
        graphics.drawImage(this.offScreen, 0, n5, this.w, n5 + this.lineHeight, 0, 0, this.w, this.lineHeight, null);
    }

    private void paintLines(Graphics graphics, int n, int n2) {
        int n3 = this.rows.size();
        if (n2 > n3) {
            n2 = n3;
        }
        int n4 = n;
        while (n4 < n2) {
            this.paintLine(graphics, n4, 0, this.columns.size());
            ++n4;
        }
        if (n2 == n3) {
            this.eraseBottom(graphics, (this.vScrollPos + n2) * this.lineHeight);
        }
    }

    void paintVisibleRows(Graphics graphics) {
        int n = -this.vScrollPos;
        int n2 = n + this.getVisibleCount();
        this.paintLines(graphics, n, n2);
    }

    private void prepareOffScreen(Graphics graphics) {
        if (this.offScreen == null) {
            this.offScreen = this.createImage(this.w, this.lineHeight);
        } else if (this.offScreen.getWidth(null) != this.w || this.offScreen.getHeight(null) != this.lineHeight) {
            this.offScreen.flush();
            this.offScreen = this.createImage(this.w, this.lineHeight);
        }
        this.offScreenGraphics = this.offScreen.getGraphics();
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this.popup != null) {
            this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void removeAdjustmentListenner(AdjustmentListener adjustmentListener) {
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, adjustmentListener);
    }

    void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    void rowsInserted(int n, int n2) {
        int n3 = n2 - n;
        if (this.showCheckmarks) {
            this.checkmarks = Util.insertBits(this.checkmarks, n, n3);
        }
        this.selections = Util.insertBits(this.selections, n, n3);
        if (n <= this.currentSelection) {
            if (this.currentSelection >= 0) {
                this.currentSelection += n3;
            }
            this.currentFocus += n3;
        }
        if (this.rows.size() - n3 > this.getCompletelyVisibleCount() && n <= -this.vScrollPos) {
            this.vScrollPos -= n2 - n;
            int n4 = -(this.rows.size() - this.getCompletelyVisibleCount());
            this.vScrollPos = Math.max(this.vScrollPos, n4);
        }
    }

    void rowsRemoved(int n, int n2) {
        if (this.showCheckmarks) {
            this.checkmarks = Util.removeBits(this.checkmarks, n, n2);
        }
        if (this.currentSelection >= n && this.currentSelection < n2) {
            this.currentSelection = -1;
        } else if (this.currentSelection >= n2) {
            this.currentSelection -= n2 - n;
        }
        if (this.currentSelection < 0) {
            this.currentSelection = -1;
        }
        if (this.currentFocus >= n2) {
            this.currentFocus -= n2 - n;
        } else if (this.currentFocus >= this.rows.size()) {
            this.currentFocus = this.rows.size() - 1;
        }
        if (this.currentFocus < 0) {
            this.currentFocus = 0;
        }
        int n3 = n;
        while (n3 < n2) {
            if (this.selections.get(n3)) {
                --this.selectionCount;
            }
            ++n3;
        }
        this.selections = Util.removeBits(this.selections, n, n2);
        if (n < -this.vScrollPos) {
            this.vScrollPos += n2 - n;
        }
        if (this.vScrollPos < 0 && -this.vScrollPos > this.rows.size() - this.getCompletelyVisibleCount()) {
            this.vScrollPos = -(this.rows.size() - this.getCompletelyVisibleCount());
        }
        if (this.vScrollPos > 0) {
            this.vScrollPos = 0;
        }
    }

    void scrollTo(int n) {
        Graphics graphics = this.getGraphics();
        int n2 = this.getVisibleCount();
        if (n < this.vScrollPos) {
            int n3;
            int n4 = this.vScrollPos - n;
            int n5 = n3 = this.getHasFillerLine() ? 1 : 0;
            if (n4 >= n2) {
                this.vScrollPos = n;
                this.paintLines(graphics, -this.vScrollPos, -this.vScrollPos + n2);
            } else {
                int n6 = n4;
                int n7 = n2 - n3;
                graphics.copyArea(0, n6 * this.lineHeight, this.w, (n7 - n6) * this.lineHeight, 0, -n4 * this.lineHeight);
                this.vScrollPos = n;
                this.paintLines(graphics, -this.vScrollPos + n7 - n4, -this.vScrollPos + n2);
                int n8 = (this.vScrollPos + this.rows.size()) * this.lineHeight;
                if (n8 < this.h) {
                    this.eraseBottom(graphics, n8);
                }
            }
        } else if (n > this.vScrollPos) {
            boolean bl;
            int n9 = n - this.vScrollPos;
            boolean bl2 = bl = this.getHasFillerLine();
            if (n9 >= n2) {
                this.vScrollPos = n;
                this.paintLines(graphics, -this.vScrollPos, -this.vScrollPos + n2);
            } else {
                int cfr_ignored_0 = n2 - n9;
                graphics.copyArea(0, 0, this.w, (n2 - n9) * this.lineHeight, 0, n9 * this.lineHeight);
                this.vScrollPos = n;
                this.paintLines(graphics, -this.vScrollPos, -this.vScrollPos + n9);
            }
        }
    }

    public void scrollToRow(int n) {
        if (n >= -this.vScrollPos && n < -this.vScrollPos + this.getCompletelyVisibleCount()) {
            return;
        }
        int n2 = Math.min(n, this.rows.size() - this.getCompletelyVisibleCount());
        if (n2 < 0) {
            n2 = 0;
        }
        this.scrollTo(-n2);
        if (this.vScrollbar != null) {
            this.vScrollbar.setValue(n2);
        }
    }

    void select(int n) {
        this.select(n, true);
    }

    void select(int n, boolean bl) {
        if (this.selections.get(n) != bl) {
            if (bl) {
                ++this.selectionCount;
                this.selections.set(n);
            } else {
                --this.selectionCount;
                this.selections.clear(n);
            }
            if (this.selectionCount == 0) {
                this.currentSelection = -1;
            } else if (this.selectionCount == 1) {
                this.currentSelection = n;
            }
            if (n >= -this.vScrollPos && n <= -this.vScrollPos + this.getVisibleCount()) {
                this.paintLine(n);
            }
        }
    }

    void selectAll() {
        int n = 0;
        while (n < this.rows.size()) {
            this.select(n, true);
            ++n;
        }
    }

    private void selectRange(int n, int n2) {
        int n3;
        int n4;
        if (n <= n2) {
            n4 = n;
            n3 = n2;
        } else {
            n4 = n2;
            n3 = n;
        }
        int n5 = n4;
        while (n5 <= n3) {
            this.select(n5, true);
            ++n5;
        }
    }

    private void selectRangeExclusive(int n, int n2) {
        int n3;
        int n4;
        if (n <= n2) {
            n4 = n;
            n3 = n2;
        } else {
            n4 = n2;
            n3 = n;
        }
        int n5 = 0;
        while (n5 < n4) {
            this.select(n5, false);
            ++n5;
        }
        n5 = n4;
        while (n5 <= n3) {
            this.select(n5, true);
            ++n5;
        }
        n5 = n3 + 1;
        while (n5 < this.rows.size()) {
            this.select(n5, false);
            ++n5;
        }
    }

    void setCheckedIndexes(int[] nArray) throws IllegalArgumentException {
        block7: {
            this.uncheckAll(false);
            try {
                try {
                    int n = 0;
                    while (n < nArray.length) {
                        this.check(nArray[n], true);
                        ++n;
                    }
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException();
                }
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                if (this.getGraphics() != null) {
                    this.paint(this.getGraphics());
                }
                throw throwable;
            }
            Object var2_5 = null;
            if (this.getGraphics() == null) break block7;
            this.paint(this.getGraphics());
        }
    }

    public void setCheckingSelects(boolean bl) {
        this.checkingSelects = bl;
    }

    public static void setCheckMarkColumnWidth(int n) {
        checkMarkColumnWidth = n;
    }

    void setColumnWidths(int[] nArray) throws IllegalArgumentException {
        if (nArray == null || this.columns.size() != nArray.length) {
            throw new IllegalArgumentException("# of columns differs from # of widths.");
        }
        this.columnWidths = nArray;
    }

    public static void setDefaultFormatter(StringFormatter stringFormatter) {
        defaultFormatter = stringFormatter;
    }

    private void setDefaultWidths() {
        this.columnWidths = new int[this.columns.size()];
        int n = 0;
        while (n < this.columnWidths.length) {
            this.columnWidths[n] = ((ColumnDefinition)this.columns.elementAt(n)).getPreferredWidth(this.getFontMetrics(this.getFont()), defaultFormatter);
            int n2 = n++;
            this.columnWidths[n2] = this.columnWidths[n2] + 8;
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.paintVisibleRows(this.getGraphics());
    }

    public static void setGridLinesColor(Color color) {
        gridLinesColor = color;
    }

    void setHorizontalScrollPos(int n) {
        this.hScrollPos = n;
    }

    public static void setLineNumberColumnWidth(int n) {
        lineNumberColumnWidth = n;
    }

    public static void setLineNumberFormatter(StringFormatter stringFormatter) {
        lineNumberFormatter = stringFormatter;
    }

    public void setPreferredHeight(int n) {
        this.preferredHeight = n;
    }

    public static void setReferenceColumnBackground(Color color) {
        referenceColumnBackground = color;
    }

    public static void setReferenceColumnBorder(Border border) {
        border.setBackground(referenceColumnBackground);
        border.setForeground(referenceColumnForeground);
        referenceColumnBorder = border;
    }

    public static void setReferenceColumnFont(Font font) {
        referenceColumnFont = font;
    }

    public static void setReferenceColumnForeground(Color color) {
        referenceColumnForeground = color;
    }

    public void setRowHeightFactor(double d) {
        this.lineHeightFactor = d;
    }

    void setRows(Vector vector) {
        this.rows = vector;
    }

    void setScrollbars(Scrollbar scrollbar, Scrollbar scrollbar2) {
        if (this.vScrollbar != null) {
            this.vScrollbar.removeAdjustmentListener(this);
        }
        if (this.hScrollbar != null) {
            this.hScrollbar.removeAdjustmentListener(this);
        }
        scrollbar.addAdjustmentListener(this);
        scrollbar2.addAdjustmentListener(this);
        this.vScrollbar = scrollbar;
        this.hScrollbar = scrollbar2;
    }

    void setSelectedIndexes(int[] nArray) throws IllegalArgumentException {
        this.deselectAll(false);
        try {
            try {
                int n = 0;
                while (n < nArray.length) {
                    this.select(nArray[n], true);
                    ++n;
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException();
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.paintVisibleRows(this.getGraphics());
            throw throwable;
        }
        Object var2_5 = null;
        this.paintVisibleRows(this.getGraphics());
    }

    void setSelectionMode(int n) {
        this.deselectAll(true);
        this.selectionMode = n;
        if (n == 1 && this.rows.size() > 0) {
            this.selections.set(0);
            this.currentSelection = 0;
            this.currentFocus = 0;
            this.selectionCount = 1;
        } else {
            this.currentSelection = -1;
            this.currentFocus = 0;
            this.selectionCount = 0;
        }
        if (this.getGraphics() != null) {
            this.paint(this.getGraphics());
        }
    }

    void setShowCheckmarks(boolean bl) {
        this.showCheckmarks = bl;
    }

    void setShowGrid(boolean bl) {
        this.showGrid = bl;
    }

    void setShowLineNumbers(boolean bl) {
        this.showLineNumbers = bl;
    }

    void setVerticalScrollPos(int n) {
        this.vScrollPos = n;
    }

    public void swapped(int n, int n2) {
        boolean bl;
        if (this.showCheckmarks) {
            bl = this.checkmarks.get(n2);
            if (this.checkmarks.get(n)) {
                this.checkmarks.set(n2);
            } else {
                this.checkmarks.clear(n2);
            }
            if (bl) {
                this.checkmarks.set(n);
            } else {
                this.checkmarks.clear(n);
            }
        }
        bl = this.selections.get(n2);
        if (this.selections.get(n)) {
            this.selections.set(n2);
        } else {
            this.selections.clear(n2);
        }
        if (bl) {
            this.selections.set(n);
        } else {
            this.selections.clear(n);
        }
        if (this.currentSelection == n) {
            this.currentSelection = n2;
        } else if (this.currentSelection == n2) {
            this.currentSelection = n;
        }
    }

    void uncheck(int n) {
        this.check(n, false);
    }

    void uncheckAll(boolean bl) {
        if (bl) {
            int n = -this.vScrollPos;
            int n2 = n + this.getVisibleCount();
            int n3 = n;
            while (n3 < n2) {
                if (this.checkmarks.get(n3)) {
                    this.checkmarks.clear(n3);
                    this.paintLine(n3);
                }
                ++n3;
            }
        }
        this.checkmarks = new BitSet();
    }

    void updateHorizontalScrollbar() {
        if (this.hScrollbar == null) {
            return;
        }
        int n = this.hScrollbar.getValue();
        int n2 = this.getSize().width;
        int n3 = this.getPreferredSize().width;
        this.hScrollbar.setValues(n, n2, 0, n3);
        this.hScrollbar.setBlockIncrement(n2);
        this.hScrollbar.setUnitIncrement(50);
    }

    void updateVerticalScrollbar() {
        if (this.vScrollbar == null) {
            return;
        }
        int n = this.getVisibleCount();
        int n2 = this.getHasFillerLine() ? 1 : 0;
        this.vScrollbar.setValues(-this.vScrollPos, n, 0, this.rows.size() + n2);
        this.vScrollbar.setBlockIncrement(n - n2);
    }
}

