/*
 * Decompiled with CFR 0.152.
 */
package tstuder.java.lib.component.table;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import tstuder.java.lib.component.table.ColumnDefinition;
import tstuder.java.lib.component.table.ColumnSortEvent;
import tstuder.java.lib.component.table.ColumnSortListener;
import tstuder.java.lib.component.table.DataArea;
import tstuder.java.lib.component.table.SimpleTableRow;
import tstuder.java.lib.component.table.TableRow;
import tstuder.java.lib.component.table.Titlebar;
import tstuder.java.lib.graphics.Border;
import tstuder.java.lib.graphics.BorderLowered2;
import tstuder.java.lib.graphics.StringFormatter;
import tstuder.java.lib.util.ColumnSortable;
import tstuder.java.lib.util.ColumnSortableVector;

public class Table
extends Container
implements PropertyChangeListener,
AdjustmentListener,
ItemSelectable,
ColumnSortListener {
    public static final int VERTICAL_SCROLLBAR_OFF = 0;
    public static final int VERTICAL_SCROLLBAR_AUTOMATIC = 1;
    public static final int VERTICAL_SCROLLBAR_ON = 2;
    public static final int HORIZONTAL_SCROLLBAR_OFF = 0;
    public static final int HORIZONTAL_SCROLLBAR_AUTOMATIC = 1;
    public static final int HORIZONTAL_SCROLLBAR_ON = 2;
    private static Color defaultBackground = Color.white;
    private static Color defaultForeground = Color.black;
    private static Border defaultBorder = new BorderLowered2();
    private Border border;
    private int borderTop;
    private int borderLeft;
    private int borderRight;
    private int borderBottom;
    private Vector rows;
    private Vector columns;
    private boolean widthsInitialized = false;
    private Titlebar titlebar;
    private boolean showTitlebar = true;
    private int titlebarSkip;
    private DataArea dataArea;
    private Scrollbar horizontalScrollbar;
    private Scrollbar verticalScrollbar;
    private int horizontalScrollMode = 1;
    private int verticalScrollMode = 1;
    private int verticalScrollbarWidth;
    private int verticalScrollbarSkip;
    private boolean hasVerticalScrollbar;
    private int horizontalScrollbarHeight;
    private int horizontalScrollbarSkip;
    private boolean hasHorizontalScrollbar;
    int w;
    int h;
    boolean isDragging;

    public Table() {
        this.columns = new Vector();
        this.columns.addElement(new ColumnDefinition("Dummy Column Title"));
        this.rows = new Vector();
        this.rows.addElement(new SimpleTableRow(new String[]{"Dummy Row"}));
        this.initialize();
    }

    public Table(Vector vector) {
        this.columns = vector;
        this.rows = new Vector();
        this.rows.addElement(new SimpleTableRow(new String[]{"Dummy Row"}));
        this.initialize();
    }

    public Table(Vector vector, Vector vector2) {
        this.columns = vector;
        this.rows = vector2;
        this.initialize();
    }

    public void add(PopupMenu popupMenu) {
        this.dataArea.add(popupMenu);
    }

    public void addActionListener(ActionListener actionListener) {
        this.dataArea.addActionListener(actionListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.dataArea.addItemListener(itemListener);
    }

    public void addRow(TableRow tableRow) {
        Vector vector = this.rows;
        synchronized (vector) {
            this.rows.addElement(tableRow);
            this.rowsAdded(1);
        }
    }

    public void adjustColumnWidth(int n) {
        int[] nArray = this.titlebar.getColumnWidths();
        nArray[n] = this.measureColumnWidth(n);
        this.setColumnWidths(nArray);
    }

    public void adjustColumnWidths() {
        int[] nArray = this.titlebar.getColumnWidths();
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.measureColumnWidth(n);
            ++n;
        }
        this.setColumnWidths(nArray);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (((Scrollbar)adjustmentEvent.getSource()).getOrientation() == 0) {
            this.titlebar.setScrollPos(-adjustmentEvent.getValue());
            this.titlebar.paint(this.titlebar.getGraphics());
        }
    }

    public void check(int n) {
        this.check(n, true);
    }

    public void check(int n, boolean bl) {
        Vector vector = this.rows;
        synchronized (vector) {
            this.dataArea.check(n, bl);
        }
    }

    public void checkAll() {
        Vector vector = this.rows;
        synchronized (vector) {
            this.dataArea.checkAll();
        }
    }

    public void checkIndexes(int[] nArray) throws IllegalArgumentException {
        Vector vector = this.rows;
        synchronized (vector) {
            this.dataArea.setCheckedIndexes(nArray);
        }
    }

    private void checkScrollbars() {
        Dimension dimension = this.dataArea.getMinimumSize();
        int n = this.getSize().width - this.borderLeft - this.borderRight;
        int n2 = this.getSize().height - this.borderTop - this.borderBottom;
        this.hasHorizontalScrollbar = this.horizontalScrollMode == 0 ? false : (this.horizontalScrollMode == 2 ? true : (dimension.width <= n - this.verticalScrollbarWidth ? false : (dimension.width > n ? true : (this.verticalScrollMode == 2 ? true : (this.verticalScrollMode == 0 ? false : this.rows.size() * dimension.height > n2 - this.titlebarSkip)))));
        int n3 = this.horizontalScrollbarSkip = this.hasHorizontalScrollbar ? this.horizontalScrollbarHeight : 0;
        this.hasVerticalScrollbar = this.verticalScrollMode == 0 ? false : (this.verticalScrollMode == 2 ? true : this.rows.size() * dimension.height > n2 - this.titlebarSkip - this.horizontalScrollbarSkip);
        this.verticalScrollbarSkip = this.hasVerticalScrollbar ? this.verticalScrollbarWidth : 0;
    }

    private void checkTitlebar() {
        Dimension dimension = this.titlebar.getPreferredSize();
        this.titlebarSkip = this.showTitlebar ? dimension.height : 0;
    }

    public void deselect(int n) {
        this.select(n, false);
    }

    public void deselectAll() {
        Vector vector = this.rows;
        synchronized (vector) {
            this.dataArea.deselectAll(true);
        }
    }

    public Color getBackground() {
        Color color = super.getBackground();
        if (color == null) {
            return defaultBackground;
        }
        return color;
    }

    public Border getBorder() {
        return this.border;
    }

    public int[] getCheckedIndexes() {
        Vector vector = this.rows;
        synchronized (vector) {
            return this.dataArea.getCheckedIndexes();
        }
    }

    public int[] getColumnWidths() {
        return this.titlebar.getColumnWidths();
    }

    public DataArea getDataArea() {
        return this.dataArea;
    }

    public static Border getDefaultBorder() {
        return defaultBorder;
    }

    public Color getForeground() {
        Color color = super.getForeground();
        if (color == null) {
            return defaultForeground;
        }
        return color;
    }

    public int getHorizontalScrollMode() {
        return this.horizontalScrollMode;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.titlebar.getMinimumSize();
        Dimension dimension2 = this.dataArea.getMinimumSize();
        int n = this.showTitlebar ? dimension.height : 0;
        return new Dimension(dimension.width + this.verticalScrollbarWidth + this.borderLeft + this.borderRight, n + dimension2.height + this.horizontalScrollbarHeight + this.borderTop + this.borderBottom);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.titlebar.getPreferredSize();
        Dimension dimension2 = this.dataArea.getPreferredSize();
        int n = this.showTitlebar ? dimension.height : 0;
        return new Dimension(dimension.width + this.borderLeft + this.borderRight + this.verticalScrollbarWidth, n + dimension2.height + this.borderTop + this.borderBottom + this.horizontalScrollbarHeight);
    }

    public Vector getRows() {
        return this.rows;
    }

    public int getSelectedIndex() {
        Vector vector = this.rows;
        synchronized (vector) {
            return this.dataArea.getSelectedIndex();
        }
    }

    public int[] getSelectedIndexes() {
        Vector vector = this.rows;
        synchronized (vector) {
            return this.dataArea.getSelectedIndexes();
        }
    }

    public Object getSelectedObject() {
        Vector vector = this.rows;
        synchronized (vector) {
            int n = this.dataArea.getSelectedIndex();
            if (n != -1) {
                return this.rows.elementAt(n);
            }
            return null;
        }
    }

    public Object[] getSelectedObjects() {
        return this.dataArea.getSelectedObjects();
    }

    public int getSelectionMode() {
        return this.dataArea.getSelectionMode();
    }

    public boolean getShowCheckmarks() {
        return this.dataArea.getShowCheckmarks();
    }

    public boolean getShowGrid() {
        return this.dataArea.getShowGrid();
    }

    public boolean getShowLineNumbers() {
        return this.dataArea.getShowLineNumbers();
    }

    public boolean getShowTitlebar() {
        return this.showTitlebar;
    }

    public Titlebar getTitlebar() {
        return this.titlebar;
    }

    public int getVerticalScrollMode() {
        return this.verticalScrollMode;
    }

    private void initialize() {
        this.setLayout(null);
        this.setBorder(defaultBorder);
        if (this.horizontalScrollMode != 0) {
            this.horizontalScrollbar = new Scrollbar(0);
        }
        if (this.verticalScrollMode != 0) {
            this.verticalScrollbar = new Scrollbar(1);
        }
        this.dataArea = new DataArea(this, this.verticalScrollbar, this.horizontalScrollbar, this.columns, this.rows);
        this.dataArea.addAdjustmentListener(this);
        this.titlebar = new Titlebar(this.columns);
        if (this.rows instanceof ColumnSortableVector) {
            this.titlebar.setCanSort(true);
            this.titlebar.addColumnSortListener(this);
            ((ColumnSortableVector)this.rows).addSwapListener(this.dataArea);
        }
        this.titlebar.addPropertyChangeListener(this);
        this.titlebar.setReferenceColumnWidth(this.dataArea.getReferenceColumnWidth());
        this.add(this.titlebar);
        this.add(this.dataArea);
        if (this.horizontalScrollbar != null) {
            this.add(this.horizontalScrollbar);
        }
        if (this.verticalScrollbar != null) {
            this.add(this.verticalScrollbar);
        }
    }

    private void initScrollbarHeight() {
        if (this.horizontalScrollbarHeight == 0 && this.horizontalScrollbar != null) {
            this.horizontalScrollbarHeight = this.horizontalScrollbar.getPreferredSize().height;
        }
    }

    private void initScrollbarWidth() {
        if (this.verticalScrollbarWidth == 0 && this.verticalScrollbar != null) {
            this.verticalScrollbarWidth = this.verticalScrollbar.getPreferredSize().width;
        }
    }

    public boolean isChecked(int n) {
        Vector vector = this.rows;
        synchronized (vector) {
            return this.dataArea.isChecked(n);
        }
    }

    public boolean isSelected(int n) {
        Vector vector = this.rows;
        synchronized (vector) {
            return this.dataArea.isSelected(n);
        }
    }

    private int measureColumnWidth(int n) {
        ColumnDefinition columnDefinition = (ColumnDefinition)this.columns.elementAt(n);
        int n2 = 0;
        switch (columnDefinition.getWidthAdjustment()) {
            case 0: {
                n2 = this.titlebar.actualColumnWidth(columnDefinition.getPreferredWidth(null, null));
                break;
            }
            case 1: {
                n2 = this.titlebar.actualColumnWidth(columnDefinition.getPreferredWidth(this.getFontMetrics(this.dataArea.getFont()), null));
                break;
            }
            case 2: {
                n2 = this.titlebar.actualColumnWidth(columnDefinition.getPreferredWidth(this.getFontMetrics(this.titlebar.getFont()), Titlebar.getDefaultFormatter()));
                break;
            }
            default: {
                Font font;
                StringFormatter stringFormatter = columnDefinition.getDataFormatter();
                if (stringFormatter == null) {
                    stringFormatter = DataArea.getDefaultFormatter();
                }
                if ((font = columnDefinition.getDataFont()) == null) {
                    font = this.dataArea.getFont();
                }
                FontMetrics fontMetrics = this.getFontMetrics(font);
                Vector vector = this.rows;
                synchronized (vector) {
                    int n3 = 0;
                    while (n3 < this.rows.size()) {
                        String string = ((TableRow)this.rows.elementAt(n3)).getStrings()[n];
                        stringFormatter.measureString(fontMetrics, string, 0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
                        if (stringFormatter.getPreferredWidth() > n2) {
                            n2 = stringFormatter.getPreferredWidth();
                        }
                        ++n3;
                    }
                }
                if (this.showTitlebar) {
                    stringFormatter = columnDefinition.getTitleFormatter();
                    if (stringFormatter == null) {
                        stringFormatter = Titlebar.getDefaultFormatter();
                    }
                    if ((font = columnDefinition.getTitleFont()) == null) {
                        font = this.titlebar.getFont();
                    }
                    fontMetrics = this.getFontMetrics(font);
                    stringFormatter.measureString(fontMetrics, columnDefinition.getTitle(), 0, 0, n2, Short.MAX_VALUE);
                    int n4 = stringFormatter.getPreferredWidth();
                    if (n4 > n2) {
                        n2 = this.titlebar.actualColumnWidth(n4);
                        break;
                    }
                    n2 = this.titlebar.actualColumnWidth(n2);
                    break;
                }
                n2 = this.dataArea.actualColumnWidth(n2);
            }
        }
        return n2;
    }

    public void paint(Graphics graphics) {
        if (this.isDragging) {
            return;
        }
        this.initScrollbarHeight();
        this.initScrollbarWidth();
        Vector vector = this.rows;
        synchronized (vector) {
            this.sizeComponents();
            if (!this.widthsInitialized) {
                this.adjustColumnWidths();
                this.widthsInitialized = true;
            }
            this.readjustHorizontalScrolling(false);
            this.readjustVerticalScrolling();
            this.paintComponents();
        }
        this.border.paint(graphics, 0, 0, this.w, this.h);
    }

    private void paintComponents() {
        if (this.showTitlebar) {
            if (!this.isDragging) {
                this.titlebar.paint(this.titlebar.getGraphics());
            }
        } else {
            this.titlebar.adjustColumns(this.dataArea.getSize().width);
        }
        this.dataArea.paint(this.dataArea.getGraphics());
        if (this.hasVerticalScrollbar && this.hasHorizontalScrollbar) {
            Graphics graphics = this.getGraphics();
            graphics.setColor(this.getBackground());
            graphics.fillRect(this.w - this.borderRight - this.verticalScrollbarWidth, this.h - this.borderBottom - this.horizontalScrollbarHeight, this.verticalScrollbarWidth, this.horizontalScrollbarHeight);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.titlebar) {
            Vector vector = this.rows;
            synchronized (vector) {
                if (propertyChangeEvent.getPropertyName() == "ColumnWidthsChanged") {
                    this.dataArea.setColumnWidths(this.titlebar.getColumnWidths());
                    this.sizeComponents();
                    this.paintComponents();
                } else if (propertyChangeEvent.getPropertyName() == "draggingStateChanged") {
                    if ((Integer)propertyChangeEvent.getNewValue() >= 0) {
                        this.isDragging = true;
                    } else {
                        this.readjustHorizontalScrolling(true);
                        this.paintComponents();
                        this.isDragging = false;
                    }
                }
            }
        }
    }

    private void readjustHorizontalScrolling(boolean bl) {
        if (this.titlebar.getScrollPos() != 0) {
            int n = this.titlebar.getSize().width;
            int n2 = this.titlebar.getPreferredSize().width;
            if (this.titlebar.getScrollPos() + n2 < n) {
                int n3 = n2 <= n ? 0 : n - n2;
                this.titlebar.setScrollPos(n3);
                this.dataArea.setHorizontalScrollPos(n3);
                if (this.horizontalScrollbar != null) {
                    this.horizontalScrollbar.setValue(-n3);
                }
                if (bl) {
                    this.paintComponents();
                }
            }
        }
    }

    private void readjustVerticalScrolling() {
        if (this.dataArea.getVerticalScrollPos() != 0) {
            int n = this.rows.size();
            int n2 = this.dataArea.getCompletelyVisibleCount();
            if (this.dataArea.getVerticalScrollPos() + n < n2) {
                int n3 = n <= n2 ? 0 : n2 - n;
                this.dataArea.setVerticalScrollPos(n3);
                if (this.verticalScrollbar != null) {
                    this.verticalScrollbar.setValue(-n3);
                }
            }
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.dataArea.removeActionListener(actionListener);
    }

    public void removeAllRows() {
        Vector vector = this.rows;
        synchronized (vector) {
            int n = this.rows.size();
            this.rows.removeAllElements();
            this.rowsRemoved(0, n);
        }
    }

    public void removeItemListener(ItemListener itemListener) {
        this.dataArea.removeItemListener(itemListener);
    }

    public void removeRowsByIndex(int[] nArray) {
        Vector vector = this.rows;
        synchronized (vector) {
            int n = nArray.length - 1;
            while (n >= 0) {
                this.rows.removeElementAt(nArray[n]);
                this.dataArea.rowsRemoved(nArray[n], nArray[n] + 1);
                --n;
            }
            this.dataArea.updateVerticalScrollbar();
            n = 1;
            if (this.verticalScrollMode == 1) {
                boolean bl = this.hasVerticalScrollbar;
                this.checkScrollbars();
                if (bl != this.hasVerticalScrollbar) {
                    this.sizeComponents();
                    n = 0;
                }
            }
            if (n != 0) {
                this.dataArea.paintVisibleRows(this.dataArea.getGraphics());
            }
        }
    }

    public void removeSelectedRows() {
        Vector vector = this.rows;
        synchronized (vector) {
            this.removeRowsByIndex(this.dataArea.getSelectedIndexes());
        }
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (!this.isDragging) {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    public void rowsAdded(int n) {
        Vector vector = this.rows;
        synchronized (vector) {
            this.rowsInserted(this.rows.size() - n, n);
        }
    }

    public void rowsInserted(int n, int n2) {
        Vector vector = this.rows;
        synchronized (vector) {
            boolean bl = true;
            int n3 = n + n2;
            this.dataArea.rowsInserted(n, n3);
            this.dataArea.updateVerticalScrollbar();
            if (this.verticalScrollMode == 1) {
                boolean bl2 = this.hasVerticalScrollbar;
                this.checkScrollbars();
                if (bl2 != this.hasVerticalScrollbar) {
                    this.sizeComponents();
                    bl = false;
                }
            }
            if (bl && n >= -this.dataArea.getVerticalScrollPos() && n <= -this.dataArea.getVerticalScrollPos() + this.dataArea.getVisibleCount()) {
                this.dataArea.paintVisibleRows(this.dataArea.getGraphics());
            }
        }
    }

    public void rowsRemoved(int n) {
        Vector vector = this.rows;
        synchronized (vector) {
            this.rowsRemoved(this.rows.size(), n);
        }
    }

    public void rowsRemoved(int n, int n2) {
        Vector vector = this.rows;
        synchronized (vector) {
            int n3 = n + n2;
            boolean bl = true;
            this.dataArea.rowsRemoved(n, n3);
            this.dataArea.updateVerticalScrollbar();
            if (this.verticalScrollMode == 1) {
                boolean bl2 = this.hasVerticalScrollbar;
                this.checkScrollbars();
                if (bl2 != this.hasVerticalScrollbar) {
                    this.sizeComponents();
                    bl = false;
                }
            }
            if (bl && n3 > -this.dataArea.getVerticalScrollPos() && n <= -this.dataArea.getVerticalScrollPos() + this.dataArea.getVisibleCount()) {
                this.dataArea.paintVisibleRows(this.dataArea.getGraphics());
            }
        }
    }

    public void rowsUpdated(int n, int n2) {
        Vector vector = this.rows;
        synchronized (vector) {
            int n3 = n + n2;
            if (n3 > -this.dataArea.getVerticalScrollPos() && n <= -this.dataArea.getVerticalScrollPos() + this.dataArea.getVisibleCount()) {
                this.dataArea.paintVisibleRows(this.dataArea.getGraphics());
            }
        }
    }

    public void scrollToRow(int n) {
        this.dataArea.scrollToRow(n);
    }

    public void select(int n) {
        this.select(n, true);
    }

    public void select(int n, boolean bl) throws IllegalArgumentException {
        Vector vector = this.rows;
        synchronized (vector) {
            int n2 = this.dataArea.getSelectionMode();
            if (bl) {
                int n3 = this.dataArea.getSelectedIndex();
                if (n2 == 1 || n2 == 0) {
                    if (n3 != n) {
                        if (n3 >= 0) {
                            this.dataArea.select(n3, false);
                        }
                        this.dataArea.moveFocus(n);
                        this.dataArea.select(n, bl);
                        this.dataArea.fireItemEvent(new ItemEvent(this, 701, this.rows.elementAt(n), 1));
                    }
                } else {
                    this.dataArea.select(n, bl);
                }
            } else if (n2 != 1) {
                this.dataArea.select(n, bl);
                if (n2 == 0) {
                    this.dataArea.fireItemEvent(new ItemEvent(this, 701, this.rows.elementAt(n), 2));
                }
            }
        }
    }

    public void selectAll() {
        Vector vector = this.rows;
        synchronized (vector) {
            this.dataArea.selectAll();
        }
    }

    public void selectIndexes(int[] nArray) throws IllegalArgumentException {
        Vector vector = this.rows;
        synchronized (vector) {
            this.dataArea.setSelectedIndexes(nArray);
        }
    }

    public void setBorder(Border border) {
        this.border = border;
        Insets insets = border.getInsets();
        this.borderTop = insets.top;
        this.borderLeft = insets.left;
        this.borderRight = insets.right;
        this.borderBottom = insets.bottom;
    }

    public void setCheckedIndexes(int[] nArray) throws IllegalArgumentException {
        Vector vector = this.rows;
        synchronized (vector) {
            this.dataArea.setCheckedIndexes(nArray);
        }
    }

    public void setColumnWidths(int[] nArray) {
        this.titlebar.setColumnWidths(nArray);
        this.dataArea.setColumnWidths(nArray);
        this.repaint();
    }

    public static void setDefaultBorder(Border border) {
        defaultBorder = border;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.horizontalScrollbar != null) {
            this.horizontalScrollbar.setEnabled(bl);
        }
        if (this.verticalScrollbar != null) {
            this.verticalScrollbar.setEnabled(bl);
        }
        if (this.titlebar != null) {
            this.titlebar.setEnabled(bl);
        }
        if (this.dataArea != null) {
            this.dataArea.setEnabled(bl);
        }
    }

    public void setHorizontalScrollMode(int n) {
        this.horizontalScrollMode = n;
    }

    public void setRows(Vector vector) {
        Vector vector2 = this.rows;
        synchronized (vector2) {
            Vector vector3 = this.rows;
            this.rows = vector;
            this.dataArea.setRows(vector);
            if (vector3.size() < this.rows.size()) {
                this.rowsAdded(this.rows.size() - vector3.size());
            } else if (vector3.size() > this.rows.size()) {
                this.rowsRemoved(vector3.size() - this.rows.size());
            } else {
                this.repaint();
            }
        }
    }

    public void setSelectionMode(int n) {
        Vector vector = this.rows;
        synchronized (vector) {
            this.dataArea.setSelectionMode(n);
        }
    }

    public void setShowCheckmarks(boolean bl) {
        this.dataArea.setShowCheckmarks(bl);
        this.titlebar.setReferenceColumnWidth(this.dataArea.getReferenceColumnWidth());
    }

    public void setShowGrid(boolean bl) {
        this.dataArea.setShowGrid(bl);
    }

    public void setShowLineNumbers(boolean bl) {
        this.dataArea.setShowLineNumbers(bl);
        this.titlebar.setReferenceColumnWidth(this.dataArea.getReferenceColumnWidth());
    }

    public void setShowTitlebar(boolean bl) {
        if (this.showTitlebar != bl) {
            this.showTitlebar = bl;
            this.titlebar.setVisible(bl);
            if (this.isVisible()) {
                this.repaint();
            }
        }
    }

    public void setSorting(int n, boolean bl) {
        this.titlebar.setSortColumn(n);
        this.titlebar.setSortAscending(bl);
    }

    public void setTableData(Vector vector, Vector vector2) {
        this.titlebar.setColumns(vector, null);
        this.columns = vector;
        this.rows = vector2;
        this.initialize();
    }

    public void setVerticalScrollMode(int n) {
        this.verticalScrollMode = n;
    }

    private void sizeComponents() {
        this.w = this.getSize().width;
        this.h = this.getSize().height;
        this.checkTitlebar();
        this.checkScrollbars();
        if (this.showTitlebar) {
            this.titlebar.setVisible(true);
            this.titlebar.setBounds(this.borderLeft, this.borderTop, this.w - this.borderLeft - this.borderRight - this.verticalScrollbarSkip, this.titlebarSkip);
        } else {
            this.titlebar.setVisible(false);
        }
        if (this.horizontalScrollbar != null) {
            this.horizontalScrollbar.setBounds(this.borderLeft, this.h - this.borderBottom - this.horizontalScrollbarHeight, this.w - this.borderLeft - this.borderRight - this.verticalScrollbarSkip, this.horizontalScrollbarHeight);
        }
        if (this.hasHorizontalScrollbar) {
            this.horizontalScrollbar.setVisible(true);
        } else {
            this.horizontalScrollbar.setVisible(false);
        }
        if (this.verticalScrollbar != null) {
            this.verticalScrollbar.setBounds(this.w - this.borderRight - this.verticalScrollbarWidth, this.borderTop, this.verticalScrollbarWidth, this.h - this.borderTop - this.borderBottom - this.horizontalScrollbarSkip);
        }
        if (this.hasVerticalScrollbar) {
            this.dataArea.setBounds(this.borderLeft, this.borderTop + this.titlebarSkip, this.w - this.borderLeft - this.borderRight - this.verticalScrollbarSkip, this.h - this.borderTop - this.borderBottom - this.horizontalScrollbarSkip - this.titlebarSkip);
            this.verticalScrollbar.setVisible(true);
        } else {
            this.verticalScrollbar.setVisible(false);
            this.dataArea.setBounds(this.borderLeft, this.borderTop + this.titlebarSkip, this.w - this.borderLeft - this.borderRight - this.verticalScrollbarSkip, this.h - this.borderTop - this.borderBottom - this.horizontalScrollbarSkip - this.titlebarSkip);
        }
    }

    public void sortColumn(ColumnSortEvent columnSortEvent) {
        if (this.rows.size() > 1) {
            ColumnSortableVector columnSortableVector = (ColumnSortableVector)this.rows;
            columnSortableVector.setAscending(columnSortEvent.getAscending());
            ColumnSortableVector columnSortableVector2 = columnSortableVector;
            synchronized (columnSortableVector2) {
                columnSortableVector.sort(columnSortEvent.getColumnIndex(), (ColumnSortable)columnSortableVector.elementAt(0));
            }
            this.dataArea.repaint();
        }
    }

    public void uncheck(int n) {
        this.check(n, false);
    }

    public void uncheckAll() {
        Vector vector = this.rows;
        synchronized (vector) {
            this.dataArea.uncheckAll(true);
        }
    }
}

