/*
 * Decompiled with CFR 0.152.
 */
package tstuder.java.lib.component.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import tstuder.java.lib.component.table.ColumnDefinition;
import tstuder.java.lib.component.table.ColumnSortEvent;
import tstuder.java.lib.component.table.ColumnSortListener;
import tstuder.java.lib.graphics.Border;
import tstuder.java.lib.graphics.BorderRaisedWithLine;
import tstuder.java.lib.graphics.DragConstraints;
import tstuder.java.lib.graphics.SortIcon;
import tstuder.java.lib.graphics.StringFormatter;

public class Titlebar
extends Component
implements MouseListener,
MouseMotionListener {
    public static final String dimensionChangedEvent = "DimensionChanged";
    public static final String columnWidthsChangedEvent = "ColumnWidthsChanged";
    public static final String draggingStateChangedEvent = "draggingStateChanged";
    public static final int NOT_DEFINED = -1;
    public static final int LEFT_MARGIN = 4;
    public static final int RIGHT_MARGIN = 4;
    public static final int TOP_MARGIN = 1;
    public static final int BOTTOM_MARGIN = 1;
    public static final int DRAG_CURSOR_RANGE = 5;
    private static Border border;
    private static int borderTop;
    private static int borderLeft;
    private static int borderRight;
    private static int borderBottom;
    private Vector columns = null;
    private int[] columnWidths = null;
    private boolean[] columnResizeableFlags = null;
    private boolean[] columnAdjustableFlags = null;
    private boolean[] columnSortableFlags = null;
    private int sortColumn = -1;
    private boolean sortAscending = true;
    private boolean canSort = false;
    private boolean adjustToFit = true;
    private int scrollPos = 0;
    private boolean doubleBuffer = true;
    private Image offScreen = null;
    private int minimumColumnWidth = 5;
    private int adjustmentIndex = 0;
    private int barWidth = -1;
    private static Color defaultBackground;
    private static Color defaultForeground;
    private static Font defaultFont;
    private static StringFormatter defaultFormatter;
    private static SortIcon sortIcon;
    private int referenceColumnWidth;
    private int w;
    private int h;
    private int lastDragX;
    private int savePreferredWidth;
    private int savePreferredHeight;
    private int dragIndex = -1;
    private int mouseOverIndex = -1;
    private boolean mouseOverSortFeedback = true;
    private DragConstraints dragConstraints;
    private Cursor savedCursor;
    private PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    private ColumnSortListener columnSortListener = null;

    static {
        Titlebar.setBorder(new BorderRaisedWithLine());
        defaultBackground = Color.lightGray;
        defaultForeground = Color.black;
        defaultFont = new Font("SansSerif", 0, 10);
        defaultFormatter = new StringFormatter();
    }

    public Titlebar() {
        this.initialize();
    }

    public Titlebar(Vector vector) {
        this.columns = vector;
        this.columnAdjustableFlags = new boolean[vector.size()];
        this.initialize();
    }

    int actualColumnWidth(int n) {
        return n + 4 + 4 + borderLeft + borderRight;
    }

    public void addColumnSortListener(ColumnSortListener columnSortListener) {
        this.columnSortListener = columnSortListener;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChange.addPropertyChangeListener(propertyChangeListener);
    }

    void adjustColumns(int n) {
        block17: {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block16: {
                if (!this.adjustToFit) {
                    return;
                }
                n6 = this.dragIndex + 1;
                n5 = n - this.getReferenceColumnWidth();
                n4 = 0;
                n3 = this.columnWidths.length - n6;
                n2 = 0;
                while (n2 < n6) {
                    n5 -= this.columnWidths[n2];
                    this.columnAdjustableFlags[n2] = false;
                    ++n2;
                }
                n2 = n6;
                while (n2 < this.columnWidths.length) {
                    n4 += this.columnWidths[n2];
                    if (this.columnResizeableFlags != null && !this.columnResizeableFlags[n2]) {
                        this.columnAdjustableFlags[n2] = false;
                        --n3;
                    } else {
                        this.columnAdjustableFlags[n2] = true;
                    }
                    ++n2;
                }
                if (n3 == 0) {
                    return;
                }
                if (n4 >= n5) break block16;
                n2 = (n5 - n4) / n3;
                int n7 = (n5 - n4) % n3;
                int n8 = n6;
                while (n8 < this.columnWidths.length) {
                    if (this.columnAdjustableFlags[n8]) {
                        int n9 = n8;
                        this.columnWidths[n9] = this.columnWidths[n9] + n2;
                        if (n7 > 0) {
                            int n10 = n8;
                            this.columnWidths[n10] = this.columnWidths[n10] + n7;
                            n7 = 0;
                        }
                    }
                    ++n8;
                }
                break block17;
            }
            if (n4 <= n5) break block17;
            n2 = n4 - n5;
            int n11 = this.columnWidths.length - n6;
            int n12 = n2 / n3;
            int n13 = n2 % n3;
            while (n2 > 0 && n3 > 0) {
                int n14 = this.adjustmentIndex % n11 + n6;
                if (this.columnAdjustableFlags[n14]) {
                    if (this.columnWidths[n14] - n13 >= this.minimumColumnWidth) {
                        n2 -= n13;
                        int n15 = n14;
                        this.columnWidths[n15] = this.columnWidths[n15] - n13;
                        n13 = 0;
                        if (this.columnWidths[n14] - n12 >= this.minimumColumnWidth) {
                            n2 -= n12;
                            int n16 = n14;
                            this.columnWidths[n16] = this.columnWidths[n16] - n12;
                        } else {
                            n2 -= this.columnWidths[n14] - this.minimumColumnWidth;
                            n13 += n12 - (this.columnWidths[n14] - this.minimumColumnWidth);
                            this.columnWidths[n14] = this.minimumColumnWidth;
                        }
                    } else {
                        n2 -= this.columnWidths[n14] - this.minimumColumnWidth;
                        n13 -= this.columnWidths[n14] - this.minimumColumnWidth;
                        this.columnWidths[n14] = this.minimumColumnWidth;
                    }
                    if (this.columnWidths[n14] == this.minimumColumnWidth) {
                        --n3;
                        this.columnAdjustableFlags[n14] = false;
                    }
                }
                ++this.adjustmentIndex;
            }
        }
    }

    private void dragColumn(int n, int n2) {
        int n3 = n;
        this.columnWidths[n3] = this.columnWidths[n3] + n2;
        this.paint(this.getGraphics());
        this.propertyChange.firePropertyChange(columnWidthsChangedEvent, null, null);
    }

    private void eraseRight(Graphics graphics, int n) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(n, 0, this.w - n, this.h);
    }

    public void finalize() throws Throwable {
        this.flush();
        super.finalize();
    }

    private int findDragIndex(int n) {
        int n2 = -1;
        int n3 = this.scrollPos + this.referenceColumnWidth;
        int n4 = 0;
        while (n4 < this.columnWidths.length) {
            if ((this.columnResizeableFlags == null || this.columnResizeableFlags[n4]) && n > (n3 += this.columnWidths[n4]) - 5 && n < n3 + 5) {
                n2 = n4;
            }
            ++n4;
        }
        return n2;
    }

    private int findSortIndex(int n) {
        int n2 = this.scrollPos + this.referenceColumnWidth;
        int n3 = 0;
        while (n3 < this.columnWidths.length) {
            if (n > n2 + 5 && n < n2 + this.columnWidths[n3] - 5) {
                if (this.columnSortableFlags == null || this.columnSortableFlags[n3]) {
                    return n3;
                }
                return -1;
            }
            n2 += this.columnWidths[n3];
            ++n3;
        }
        return -1;
    }

    public void flush() {
        if (this.offScreen != null) {
            this.offScreen.flush();
            this.offScreen = null;
        }
    }

    public boolean getAdjustToFit() {
        return this.adjustToFit;
    }

    public Color getBackground() {
        Color color = super.getBackground();
        if (color == null) {
            return defaultBackground;
        }
        return color;
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public boolean getCanSort() {
        return this.canSort;
    }

    public boolean[] getColumnResizeableFlags() {
        return this.columnResizeableFlags;
    }

    public boolean[] getColumnSortableFlags() {
        return this.columnSortableFlags;
    }

    public int[] getColumnWidths() {
        return this.columnWidths;
    }

    public static Color getDefaultBackground() {
        return defaultBackground;
    }

    public static Font getDefaultFont() {
        return defaultFont;
    }

    public static Color getDefaultForeground() {
        return defaultForeground;
    }

    public static StringFormatter getDefaultFormatter() {
        return defaultFormatter;
    }

    public boolean getDoubleBuffer() {
        return this.doubleBuffer;
    }

    public Font getFont() {
        Font font = super.getFont();
        if (font == null) {
            return defaultFont;
        }
        return font;
    }

    public Color getForeground() {
        Color color = super.getForeground();
        if (color == null) {
            return defaultForeground;
        }
        return color;
    }

    public int getMinimumColumnWidth() {
        return this.minimumColumnWidth;
    }

    public Dimension getMinimumSize() {
        int n = this.barWidth == -1 ? 8 + borderLeft + borderRight + this.referenceColumnWidth : this.barWidth;
        int n2 = 2 + borderTop + borderBottom;
        return new Dimension(n, n2);
    }

    public boolean getMouseOverSortFeedback() {
        return this.mouseOverSortFeedback;
    }

    public Dimension getPreferredSize() {
        if (this.columns == null || this.columns.size() == 0) {
            return this.getMinimumSize();
        }
        int n = 0;
        int n2 = 0;
        if (this.columnWidths == null) {
            this.setDefaultWidths();
        }
        int n3 = 0;
        while (n3 < this.columnWidths.length) {
            n2 += this.columnWidths[n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < this.columns.size()) {
            int n4 = ((ColumnDefinition)this.columns.elementAt(n3)).getPreferredTitleHeight(this.getFontMetrics(this.getFont()), defaultFormatter, this.columnWidths[n3] - borderLeft - borderRight - 4 - 4);
            if (n4 > n) {
                n = n4;
            }
            ++n3;
        }
        n += borderTop + borderBottom + 1 + 1;
        if (this.barWidth == -1) {
            return new Dimension(n2 + this.referenceColumnWidth, n);
        }
        return new Dimension(this.barWidth, n);
    }

    public int getReferenceColumnWidth() {
        return this.referenceColumnWidth;
    }

    public int getScrollPos() {
        return this.scrollPos;
    }

    public boolean getSortAscending() {
        return this.sortAscending;
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    protected SortIcon getSortIconInstance() {
        if (sortIcon == null) {
            sortIcon = new SortIcon(this);
        }
        return sortIcon;
    }

    private void initialize() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dragIndex >= 0) {
            int n = this.dragConstraints.dragHorizontally(mouseEvent.getX());
            this.dragColumn(this.dragIndex, n - this.lastDragX);
            this.lastDragX = n;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.savedCursor = this.getCursor();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.savedCursor != null) {
            this.setCursor(this.savedCursor);
        }
        if (this.canSort) {
            this.mouseOverIndex = -1;
            this.paint(this.getGraphics());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        int n = mouseEvent.getX();
        if (this.canSort && this.mouseOverSortFeedback) {
            int n2 = this.mouseOverIndex;
            this.mouseOverIndex = this.findSortIndex(n);
            if (n2 != this.mouseOverIndex) {
                this.paint(this.getGraphics());
            }
        }
        if (this.findDragIndex(n) >= 0) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        if (!this.isEnabled()) {
            return;
        }
        int n2 = mouseEvent.getX();
        Integer n3 = new Integer(this.dragIndex);
        this.dragIndex = this.findDragIndex(n2);
        if (this.dragIndex >= 0) {
            Dimension dimension = this.getPreferredSize();
            this.savePreferredWidth = dimension.width;
            this.savePreferredHeight = dimension.height;
            int n4 = this.scrollPos + this.referenceColumnWidth;
            int n5 = 0;
            while (n5 < this.dragIndex) {
                n4 += this.columnWidths[n5];
                ++n5;
            }
            this.dragConstraints = new DragConstraints(n4 + this.minimumColumnWidth, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.lastDragX = this.dragConstraints.dragHorizontally(n4 + this.columnWidths[n5]);
            this.propertyChange.firePropertyChange(draggingStateChangedEvent, n3, new Integer(this.dragIndex));
        } else if (this.canSort && this.columnSortListener != null && (n = this.findSortIndex(n2)) >= 0) {
            if (n == this.sortColumn) {
                this.sortAscending = !this.sortAscending;
            } else {
                this.sortColumn = n;
                this.sortAscending = true;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.columnSortListener.sortColumn(new ColumnSortEvent(this, this.sortColumn, this.sortAscending));
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dragIndex != -1) {
            Integer n = new Integer(this.dragIndex);
            this.dragIndex = -1;
            this.propertyChange.firePropertyChange(draggingStateChangedEvent, n, new Integer(this.dragIndex));
            Dimension dimension = this.getPreferredSize();
            if (this.savePreferredWidth != dimension.width || this.savePreferredHeight != dimension.height) {
                this.propertyChange.firePropertyChange(dimensionChangedEvent, new Dimension(this.savePreferredWidth, this.savePreferredHeight), dimension);
            }
        }
        this.paint(this.getGraphics());
        if (this.adjustToFit) {
            this.propertyChange.firePropertyChange(columnWidthsChangedEvent, null, null);
        }
    }

    public void paint(Graphics graphics) {
        this.w = this.getSize().width;
        this.h = this.getSize().height;
        Graphics graphics2 = this.prepareOffScreen(graphics);
        int n = this.scrollPos + this.referenceColumnWidth;
        if (this.columns != null && this.columns.size() > 0) {
            if (this.columnWidths == null) {
                this.setDefaultWidths();
            }
            this.adjustColumns(this.w);
            int n2 = 0;
            while (n2 < this.columns.size()) {
                ColumnDefinition columnDefinition = (ColumnDefinition)this.columns.elementAt(n2);
                this.paintOneTitle(graphics2, n2, n, columnDefinition);
                n += this.columnWidths[n2];
                ++n2;
            }
        }
        this.paintReferenceColumn(graphics2);
        if (n < this.w) {
            this.eraseRight(graphics2, n);
        }
        if (this.doubleBuffer) {
            graphics.drawImage(this.offScreen, 0, 0, this.w, this.h, 0, 0, this.w, this.h, null);
        }
    }

    private void paintOneTitle(Graphics graphics, int n, int n2, ColumnDefinition columnDefinition) {
        int n3 = this.columnWidths[n];
        int n4 = this.h;
        if (n3 == 0) {
            return;
        }
        Color color = columnDefinition.getTitleBackground();
        if (color == null) {
            color = this.getBackground();
        }
        border.setBackground(color);
        border.paint(graphics, n2, 0, n3, n4);
        int n5 = n2 + borderLeft;
        int n6 = borderTop;
        graphics.setColor(color);
        graphics.fillRect(n2 + borderLeft, borderTop, n3 -= borderLeft + borderRight, n4 -= borderTop + borderBottom);
        ++n6;
        n4 -= 2;
        if ((n5 += 4) + (n3 -= 8) >= 0 && n5 < this.w) {
            if (this.canSort && (this.columnSortableFlags == null || this.columnSortableFlags[n]) && (n == this.sortColumn || n == this.mouseOverIndex)) {
                this.paintOneTitleString(graphics, columnDefinition, n5, n6, n3 - 9, n4);
                if (n3 > 9) {
                    if (n == this.sortColumn) {
                        boolean bl = n == this.mouseOverIndex ? !this.sortAscending : this.sortAscending;
                        this.getSortIconInstance().paint(graphics, bl, n5 + n3 - 9, 0, 9, this.h);
                    } else {
                        this.getSortIconInstance().paint(graphics, true, n5 + n3 - 9, 0, 9, this.h);
                    }
                }
            } else {
                this.paintOneTitleString(graphics, columnDefinition, n5, n6, n3, n4);
            }
        }
    }

    private void paintOneTitleString(Graphics graphics, ColumnDefinition columnDefinition, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics;
        Font font = columnDefinition.getTitleFont();
        if (font == null) {
            font = this.getFont();
            fontMetrics = this.getFontMetrics(font);
        } else {
            fontMetrics = columnDefinition.getTitleFontMetrics();
        }
        Shape shape = graphics.getClip();
        int n5 = Math.max(n, 0);
        int n6 = Math.min(n + n3, this.w);
        graphics.setClip(n5, n2, n6 - n5, n4);
        graphics.setFont(font);
        Color color = columnDefinition.getTitleForeground();
        if (color == null) {
            color = this.getForeground();
        }
        graphics.setColor(color);
        StringFormatter stringFormatter = columnDefinition.getTitleFormatter();
        if (stringFormatter == null) {
            stringFormatter = defaultFormatter;
        }
        stringFormatter.formatString(graphics, fontMetrics, columnDefinition.getTitle(), n, n2, n3, n4);
        graphics.setClip(shape);
    }

    private void paintReferenceColumn(Graphics graphics) {
        if (this.referenceColumnWidth == 0) {
            return;
        }
        int n = this.referenceColumnWidth;
        int n2 = this.h;
        Color color = this.getBackground();
        border.setBackground(color);
        border.paint(graphics, 0, 0, n, n2);
        graphics.setColor(color);
        graphics.fillRect(borderLeft, borderTop, n -= borderLeft + borderRight, n2 -= borderTop + borderBottom);
    }

    private Graphics prepareOffScreen(Graphics graphics) {
        if (this.doubleBuffer && this.w > 0 && this.h > 0) {
            if (this.offScreen == null) {
                this.offScreen = this.createImage(this.w, this.h);
            } else if (this.offScreen.getWidth(null) != this.w || this.offScreen.getHeight(null) != this.h) {
                this.offScreen.flush();
                this.offScreen = this.createImage(this.w, this.h);
            }
            return this.offScreen.getGraphics();
        }
        return graphics;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChange.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAdjustToFit(boolean bl) {
        this.adjustToFit = bl;
    }

    public void setBarWidth(int n) {
        this.barWidth = n;
    }

    public static void setBorder(Border border) {
        Titlebar.border = border;
        Insets insets = border.getInsets();
        borderTop = insets.top;
        borderLeft = insets.left;
        borderRight = insets.right;
        borderBottom = insets.bottom;
    }

    public void setCanSort(boolean bl) {
        this.canSort = bl;
    }

    public void setColumnResizeableFlags(boolean[] blArray) throws IllegalArgumentException {
        if (blArray == null || this.columns.size() != blArray.length) {
            throw new IllegalArgumentException("# of columns differs from # of resizeable flags.");
        }
        this.columnResizeableFlags = blArray;
    }

    public void setColumns(Vector vector, int[] nArray) throws IllegalArgumentException {
        if (nArray != null && vector.size() != nArray.length) {
            throw new IllegalArgumentException("# of columns differs from # of widths.");
        }
        this.columns = vector;
        this.columnWidths = nArray;
        this.columnAdjustableFlags = new boolean[vector.size()];
    }

    public void setColumnSortableFlags(boolean[] blArray) throws IllegalArgumentException {
        if (blArray == null || this.columns.size() != blArray.length) {
            throw new IllegalArgumentException("# of columns differs from # of sortable flags.");
        }
        this.columnSortableFlags = blArray;
    }

    public void setColumnWidths(int[] nArray) throws IllegalArgumentException {
        if (nArray == null || this.columns.size() != nArray.length) {
            throw new IllegalArgumentException("# of columns differs from # of widths.");
        }
        this.columnWidths = nArray;
    }

    public static void setDefaultBackground(Color color) {
        defaultBackground = color;
    }

    public static void setDefaultFont(Font font) {
        defaultFont = font;
    }

    public static void setDefaultForeground(Color color) {
        defaultForeground = color;
    }

    public static void setDefaultFormatter(StringFormatter stringFormatter) {
        defaultFormatter = stringFormatter;
    }

    protected void setDefaultWidths() {
        this.columnWidths = new int[this.columns.size()];
        int n = 0;
        while (n < this.columnWidths.length) {
            this.columnWidths[n] = ((ColumnDefinition)this.columns.elementAt(n)).getPreferredWidth(this.getFontMetrics(this.getFont()), defaultFormatter);
            this.columnWidths[n] = this.actualColumnWidth(this.columnWidths[n]);
            ++n;
        }
    }

    public void setDoubleBuffer(boolean bl) {
        this.doubleBuffer = bl;
        if (!bl) {
            this.flush();
        }
    }

    public void setMinimumColumnWidth(int n) {
        this.minimumColumnWidth = n;
    }

    public void setMouseOverSortFeedback(boolean bl) {
        this.mouseOverSortFeedback = bl;
    }

    public void setReferenceColumnWidth(int n) {
        this.referenceColumnWidth = n;
    }

    public void setScrollPos(int n) {
        this.scrollPos = n;
    }

    public void setSortAscending(boolean bl) {
        this.sortAscending = bl;
    }

    public void setSortColumn(int n) {
        this.sortColumn = n;
    }
}

