/*
 * Decompiled with CFR 0.152.
 */
package tstuder.java.lib.graphics;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import tstuder.java.lib.graphics.StringWrapFormatter;

public class ColorStringWrapFormatter
extends StringWrapFormatter {
    private Color[] colors;
    private int toggleCount;
    private int[] toggleVector;
    private int[] colorVector;

    public ColorStringWrapFormatter() {
        Color[] colorArray = new Color[10];
        colorArray[1] = Color.red;
        colorArray[2] = Color.green;
        colorArray[3] = Color.blue;
        colorArray[4] = Color.magenta;
        colorArray[5] = Color.cyan;
        colorArray[6] = Color.yellow;
        colorArray[7] = Color.darkGray;
        colorArray[8] = Color.gray;
        colorArray[9] = Color.lightGray;
        this.colors = colorArray;
        this.toggleVector = new int[8];
        this.colorVector = new int[8];
    }

    public ColorStringWrapFormatter(int n, int n2) {
        super(n, n2);
        Color[] colorArray = new Color[10];
        colorArray[1] = Color.red;
        colorArray[2] = Color.green;
        colorArray[3] = Color.blue;
        colorArray[4] = Color.magenta;
        colorArray[5] = Color.cyan;
        colorArray[6] = Color.yellow;
        colorArray[7] = Color.darkGray;
        colorArray[8] = Color.gray;
        colorArray[9] = Color.lightGray;
        this.colors = colorArray;
        this.toggleVector = new int[8];
        this.colorVector = new int[8];
    }

    public ColorStringWrapFormatter(int n, int n2, int[] nArray, int n3) {
        super(n, n2, nArray, n3);
        Color[] colorArray = new Color[10];
        colorArray[1] = Color.red;
        colorArray[2] = Color.green;
        colorArray[3] = Color.blue;
        colorArray[4] = Color.magenta;
        colorArray[5] = Color.cyan;
        colorArray[6] = Color.yellow;
        colorArray[7] = Color.darkGray;
        colorArray[8] = Color.gray;
        colorArray[9] = Color.lightGray;
        this.colors = colorArray;
        this.toggleVector = new int[8];
        this.colorVector = new int[8];
    }

    private int colorParse(String string, char[] cArray) {
        int n = 0;
        boolean bl = false;
        this.toggleCount = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (bl) {
                if (c == '~') {
                    cArray[n++] = 126;
                } else {
                    if (this.toggleVector.length == this.toggleCount) {
                        this.increaseCapacity();
                    }
                    cArray[n++] = 10;
                    this.toggleVector[this.toggleCount] = n;
                    this.colorVector[this.toggleCount] = Character.digit(c, 10);
                    ++this.toggleCount;
                }
                bl = false;
            } else if (c == '~') {
                bl = true;
            } else {
                cArray[n++] = c;
            }
            ++n2;
        }
        return n;
    }

    public void formatString(Graphics graphics, FontMetrics fontMetrics, String string, int n, int n2, int n3, int n4) {
        int n5 = 0;
        this.setUpBuffers(string);
        int n6 = this.colorParse(string, this.charBuf);
        if (graphics != null) {
            this.colors[0] = graphics.getColor();
        }
        this.wrap(fontMetrics, this.charBuf, 0, n6, n3);
        int n7 = fontMetrics.getHeight();
        int n8 = this.lineCount * n7;
        int n9 = 0;
        int n10 = this.vAlignment == 4 ? (n4 + n8) / 2 - n8 + n7 : (this.vAlignment == 8 ? n4 - n8 + n7 : n7);
        n10 = n2 + n10 - fontMetrics.getDescent();
        int n11 = 0;
        while (n11 < this.lineCount) {
            int n12;
            int n13 = n12 = n5 < this.toggleCount ? this.toggleVector[n5] : n6;
            if (n12 == this.startIndexes[n11] && graphics != null) {
                graphics.setColor(this.colors[this.colorVector[n5++]]);
            }
            this.drawChars(graphics, fontMetrics, this.charBuf, this.startIndexes[n11], this.pastIndexes[n11] - this.startIndexes[n11], n, n10, n3);
            n10 += n7;
            if (this.preferredWidth > n9) {
                n9 = this.preferredWidth;
            }
            ++n11;
        }
        this.preferredHeight = n8;
        this.preferredWidth = n9;
    }

    private void increaseCapacity() {
        int n = this.toggleVector.length;
        int[] nArray = new int[n * 2];
        int[] nArray2 = new int[n * 2];
        System.arraycopy(this.toggleVector, 0, nArray, 0, n);
        System.arraycopy(this.colorVector, 0, nArray2, 0, n);
        this.toggleVector = nArray;
        this.colorVector = nArray2;
    }

    public boolean isWrappingFormatter() {
        return true;
    }

    public void setColors(Color[] colorArray) {
        this.colors = new Color[colorArray.length + 1];
        int n = 0;
        while (n < colorArray.length) {
            this.colors[n + 1] = colorArray[n];
            ++n;
        }
    }
}

