/*
 * Decompiled with CFR 0.152.
 */
package tstuder.java.lib.graphics;

import java.awt.FontMetrics;
import java.awt.Graphics;

public class StringFormatter {
    public static final int ALIGNMENT_LEFT = 1;
    public static final int ALIGNMENT_LEFT_WITH_TABS = 2;
    public static final int ALIGNMENT_CENTER = 4;
    public static final int ALIGNMENT_RIGHT = 8;
    public static final int ALIGNMENT_RIGHT_DECIMAL = 16;
    public static final int ALIGNMENT_TOP = 2;
    public static final int ALIGNMENT_VCENTER = 4;
    public static final int ALIGNMENT_BOTTOM = 8;
    public static final int DEFAULT_NUM_DECIMALS = 2;
    protected int hAlignment = 1;
    protected int vAlignment = 2;
    private int[] tabstops = null;
    private boolean clip = true;
    private int decTabstop = 3;
    private static char decimalDelimiter = (char)46;
    private static char[] dotsString = new char[]{'.', '.'};
    protected int lineCount;
    protected boolean wasClipped;
    protected int preferredHeight;
    protected int preferredWidth;

    public StringFormatter() {
        this(1, 2, null, 2);
    }

    public StringFormatter(int n, int n2) {
        this(n, n2, null, 2);
    }

    public StringFormatter(int n, int n2, int[] nArray, int n3) {
        this.hAlignment = n;
        this.vAlignment = n2;
        this.tabstops = nArray;
        this.decTabstop = n3;
    }

    public int calcBaselineOffset(FontMetrics fontMetrics, int n) {
        switch (this.vAlignment) {
            case 8: {
                return n - fontMetrics.getDescent();
            }
            case 4: {
                return (n + fontMetrics.getHeight()) / 2 - fontMetrics.getDescent();
            }
        }
        return fontMetrics.getHeight() - fontMetrics.getDescent();
    }

    private final void drawAligned(Graphics graphics, FontMetrics fontMetrics, char[] cArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n2 > 0) {
            switch (n7) {
                case 1: {
                    graphics.drawChars(cArray, n, n2, n3, n4);
                    break;
                }
                case 8: {
                    graphics.drawChars(cArray, n, n2, n3 + n5 - n6, n4);
                    break;
                }
                case 4: {
                    graphics.drawChars(cArray, n, n2, n3 + (n5 - n6) / 2, n4);
                }
            }
        }
    }

    public final void drawChars(Graphics graphics, FontMetrics fontMetrics, char[] cArray, int n, int n2, int n3, int n4, int n5) {
        this.preferredHeight = fontMetrics.getHeight();
        this.preferredWidth = 0;
        this.lineCount = 1;
        this.wasClipped = false;
        if (n2 == 0) {
            return;
        }
        if (this.hAlignment == 16) {
            this.drawCharsDecimal(graphics, fontMetrics, cArray, n, n2, n3, n4, n5);
        } else if (this.hAlignment == 2) {
            this.drawCharsTabbed(graphics, fontMetrics, cArray, n, n2, n3, n4, n5);
        } else {
            int n6;
            this.preferredWidth = n6 = fontMetrics.charsWidth(cArray, n, n2);
            if (n6 <= n5) {
                if (graphics != null) {
                    this.drawAligned(graphics, fontMetrics, cArray, n, n2, n3, n4, n5, n6, this.hAlignment);
                }
            } else if (!this.clip) {
                this.wasClipped = true;
                if (graphics != null) {
                    this.drawAligned(graphics, fontMetrics, cArray, n, n2, n3, n4, n5, n6, this.hAlignment);
                }
            } else {
                this.wasClipped = true;
                if (graphics != null) {
                    this.drawClipped(graphics, fontMetrics, cArray, n, n2, n3, n4, n5, n6, this.hAlignment);
                }
            }
        }
    }

    private final void drawCharsDecimal(Graphics graphics, FontMetrics fontMetrics, char[] cArray, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = fontMetrics.charWidth('0');
        if (n5 < n7) {
            return;
        }
        int n8 = this.decTabstop * n7 + fontMetrics.charWidth(decimalDelimiter);
        n8 = Math.min(n8, n5 - n7);
        int n9 = Math.max(n7, n5 - n8);
        int n10 = n + n2 - 1;
        while (n10 >= n) {
            if (cArray[n10] == decimalDelimiter) break;
            --n10;
        }
        if (n10 < n) {
            n6 = fontMetrics.charsWidth(cArray, n, n2);
            if (n6 <= n9) {
                if (graphics != null) {
                    this.drawAligned(graphics, fontMetrics, cArray, n, n2, n3, n4, n9, n6, 8);
                }
            } else {
                if (graphics != null) {
                    this.drawClippedLeft(graphics, fontMetrics, cArray, n, n2, n3, n4, n9, n6);
                }
                this.wasClipped = true;
            }
        } else {
            int n11 = n10 - n;
            n6 = fontMetrics.charsWidth(cArray, n, n11);
            if (n6 <= n9) {
                if (graphics != null) {
                    this.drawAligned(graphics, fontMetrics, cArray, n, n11, n3, n4, n9, n6, 8);
                }
            } else {
                if (graphics != null) {
                    this.drawClippedLeft(graphics, fontMetrics, cArray, n, n11, n3, n4, n9, n6);
                }
                this.wasClipped = true;
            }
            if ((n6 = fontMetrics.charsWidth(cArray, n10, n11 = n2 - n10)) <= n8) {
                if (graphics != null) {
                    this.drawAligned(graphics, fontMetrics, cArray, n10, n11, n3 + n9, n4, n8, n6, 1);
                }
            } else if (n11 > 2 || n11 == 2 && cArray[n10 + 1] != '0') {
                if (graphics != null) {
                    this.drawClipped(graphics, fontMetrics, cArray, n10, n11, n3 + n9, n4, n8, n6, 1);
                }
                this.wasClipped = true;
            }
        }
        this.preferredWidth = n6 + n8;
    }

    private final void drawCharsTabbed(Graphics graphics, FontMetrics fontMetrics, char[] cArray, int n, int n2, int n3, int n4, int n5) {
        if (this.tabstops == null) {
            int n6;
            this.preferredWidth = n6 = fontMetrics.charsWidth(cArray, n, n2);
            if (n6 <= n5) {
                if (graphics != null && n2 > 0) {
                    graphics.drawChars(cArray, n, n2, n3, n4);
                }
            } else {
                this.wasClipped = true;
                if (graphics != null) {
                    this.drawClipped(graphics, fontMetrics, cArray, n, n2, n3, n4, n5, n6, 1);
                }
            }
        } else {
            int n7 = fontMetrics.charWidth('0');
            int n8 = 0;
            int n9 = n;
            int n10 = n3;
            int n11 = n3 + n5;
            int n12 = n + n2;
            int n13 = this.nextTabIndex(cArray, n, n2);
            int n14 = n13 - n9;
            while (true) {
                int n15;
                int n16;
                if (n10 + (n16 = n8 >= this.tabstops.length || n13 == n12 ? Short.MAX_VALUE : this.tabstops[n8] * n7) > n11) {
                    n16 = n11 - n10;
                }
                if ((n15 = fontMetrics.charsWidth(cArray, n9, n14)) <= n16) {
                    if (graphics != null && n14 > 0) {
                        graphics.drawChars(cArray, n9, n14, n10, n4);
                    }
                    if (n13 >= n12) {
                        this.preferredWidth = n10 + n15 - n3;
                        return;
                    }
                } else {
                    if (graphics != null) {
                        this.drawClipped(graphics, fontMetrics, cArray, n9, n14, n10, n4, n16, n15, 1);
                    }
                    if (n13 >= n12) {
                        this.wasClipped = true;
                        this.preferredWidth = n10 + n15 - n3;
                        return;
                    }
                }
                ++n8;
                n10 += n16;
                n13 = this.nextTabIndex(cArray, n9 += n14 + 1, n2 - n9);
                n14 = n13 - n9;
            }
        }
    }

    private final void drawClipped(Graphics graphics, FontMetrics fontMetrics, char[] cArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = fontMetrics.charsWidth(dotsString, 0, 2);
        int n9 = n + n2 - 1;
        n6 += n8;
        while (n9 >= n && n6 > n5) {
            n6 -= fontMetrics.charWidth(cArray[n9--]);
        }
        int n10 = n9 - n + 1;
        switch (n7) {
            case 1: {
                if (n10 > 0) {
                    graphics.drawChars(cArray, n, n10, n3, n4);
                }
                graphics.drawChars(dotsString, 0, 2, n3 + n6 - n8, n4);
                break;
            }
            case 8: {
                if (n10 > 0) {
                    graphics.drawChars(cArray, n, n10, n3 + n5 - n6, n4);
                }
                n3 = Math.max(n3 + n5 - n8, n3);
                graphics.drawChars(dotsString, 0, 2, n3, n4);
                break;
            }
            case 4: {
                int n11 = n3 + (n5 - n6) / 2;
                if (n10 > 0) {
                    graphics.drawChars(cArray, n, n10, n11, n4);
                }
                n11 = Math.max(n11 + n6 - n8, n3);
                graphics.drawChars(dotsString, 0, 2, n11, n4);
            }
        }
    }

    private final void drawClippedLeft(Graphics graphics, FontMetrics fontMetrics, char[] cArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = fontMetrics.charsWidth(dotsString, 0, 2);
        int n8 = n;
        n6 += n7;
        int n9 = n + n2 - 1;
        while (n8 <= n9 && n6 > n5) {
            n6 -= fontMetrics.charWidth(cArray[n8++]);
        }
        int n10 = n9 - n8 + 1;
        graphics.drawChars(dotsString, 0, 2, Math.max(n3, n3 + n5 - n6), n4);
        if (n10 > 0) {
            graphics.drawChars(cArray, n8, n10, n3 + n5 - n6 + n7, n4);
        }
    }

    public void formatString(Graphics graphics, FontMetrics fontMetrics, String string, int n, int n2, int n3, int n4) {
        this.drawChars(graphics, fontMetrics, string.toCharArray(), 0, string.length(), n, n2 + this.calcBaselineOffset(fontMetrics, n4), n3);
    }

    public final boolean getClip() {
        return this.clip;
    }

    public static char getDecimalDelimiter() {
        return decimalDelimiter;
    }

    public final int getDecTabstop() {
        return this.decTabstop;
    }

    public final int getHAlignment() {
        return this.hAlignment;
    }

    public final int getLineCount() {
        return this.lineCount;
    }

    public final int getPreferredHeight() {
        return this.preferredHeight;
    }

    public final int getPreferredWidth() {
        return this.preferredWidth;
    }

    public final int[] getTabstops() {
        return this.tabstops;
    }

    public final int getVAlignment() {
        return this.vAlignment;
    }

    public boolean isWrappingFormatter() {
        return false;
    }

    public void measureString(FontMetrics fontMetrics, String string, int n, int n2, int n3, int n4) {
        this.formatString(null, fontMetrics, string, n, n2, n3, n4);
    }

    private int nextTabIndex(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            if (cArray[n] == '\t') break;
            ++n;
        }
        return n;
    }

    public void setClipEnabled(boolean bl) {
        this.clip = bl;
    }

    public static void setDecimalDelimiter(char c) {
        decimalDelimiter = c;
    }

    public final void setDecTabstop(int n) {
        this.decTabstop = n;
    }

    public final void setHAlignment(int n) {
        this.hAlignment = n;
    }

    public final void setTabstops(int[] nArray) {
        this.tabstops = nArray;
    }

    public final void setVAlignment(int n) {
        this.vAlignment = n;
    }

    public final boolean wasClipped() {
        return this.wasClipped;
    }
}

