/*
 * Decompiled with CFR 0.152.
 */
package tstuder.java.lib.graphics;

import java.awt.FontMetrics;
import java.awt.Graphics;
import tstuder.java.lib.graphics.StringFormatter;

public class StringWrapFormatter
extends StringFormatter {
    protected char[] normalWrapCharacters = new char[]{' ', '\n', '_'};
    protected char[] persistentWrapCharacters = new char[]{'-', '/'};
    protected boolean wrap = true;
    protected static final int MAX_CLEAR_COUNTER = 1024;
    protected int clearCounter = 0;
    protected int[] startIndexes;
    protected int[] pastIndexes;
    protected char[] charBuf;
    protected int lineCount;
    protected boolean normalWrap;

    public StringWrapFormatter() {
    }

    public StringWrapFormatter(int n, int n2) {
        super(n, n2);
    }

    public StringWrapFormatter(int n, int n2, int[] nArray, int n3) {
        super(n, n2, nArray, n3);
    }

    public void formatString(Graphics graphics, FontMetrics fontMetrics, String string, int n, int n2, int n3, int n4) {
        this.setUpBuffers(string);
        string.getChars(0, string.length(), this.charBuf, 0);
        this.wrap(fontMetrics, this.charBuf, 0, string.length(), n3);
        int n5 = fontMetrics.getHeight();
        int n6 = this.lineCount * n5;
        int n7 = 0;
        int n8 = this.vAlignment == 4 ? (n4 + n6) / 2 - n6 + n5 : (this.vAlignment == 8 ? n4 - n6 + n5 : n5);
        n8 = n2 + n8 - fontMetrics.getDescent();
        int n9 = 0;
        while (n9 < this.lineCount) {
            this.drawChars(graphics, fontMetrics, this.charBuf, this.startIndexes[n9], this.pastIndexes[n9] - this.startIndexes[n9], n, n8, n3);
            n8 += n5;
            if (this.preferredWidth > n7) {
                n7 = this.preferredWidth;
            }
            ++n9;
        }
        this.preferredHeight = n6;
        this.preferredWidth = n7;
    }

    public char[] getNormalWrapCharacters() {
        return this.normalWrapCharacters;
    }

    public char[] getPersistentWrapCharacters() {
        return this.persistentWrapCharacters;
    }

    public boolean getWrap() {
        return this.wrap;
    }

    private boolean isNormalWrapCharacter(char c) {
        int n = 0;
        while (n < this.normalWrapCharacters.length) {
            if (this.normalWrapCharacters[n] == c) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isPersistentWrapCharacter(char c) {
        int n = 0;
        while (n < this.persistentWrapCharacters.length) {
            if (this.persistentWrapCharacters[n] == c) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isWrappingFormatter() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private int nextStartIndex(char[] var1_1, int var2_2, int var3_3) {
        if (var2_2 >= var3_3 || var1_1[var2_2] != '\n') ** GOTO lbl4
        return var2_2 + 1;
lbl-1000:
        // 1 sources

        {
            ++var2_2;
lbl4:
            // 2 sources

            ** while (var2_2 < var3_3 && this.isNormalWrapCharacter((char)var1_1[var2_2]))
        }
lbl5:
        // 2 sources

        while (var2_2 < var3_3 && this.isPersistentWrapCharacter(var1_1[var2_2])) {
            ++var2_2;
        }
        return var2_2;
    }

    /*
     * Unable to fully structure code
     */
    private int nextWrapIndex(char[] var1_1, int var2_2, int var3_3) {
        block5: {
            if (!this.wrap) ** GOTO lbl15
            while (var2_2 < var3_3) {
                if (this.isPersistentWrapCharacter(var1_1[var2_2])) {
                    this.normalWrap = false;
                    return var2_2 + 1;
                }
                if (this.isNormalWrapCharacter(var1_1[var2_2])) {
                    this.normalWrap = true;
                    return var2_2;
                }
                ++var2_2;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                if (var1_1[var2_2] == '\n') {
                    return var2_2;
                }
                ++var2_2;
lbl15:
                // 2 sources

                ** while (var2_2 < var3_3)
            }
        }
        return var3_3;
    }

    private void setLineIndexes(int n, int n2, int n3) {
        if (n >= this.startIndexes.length) {
            int[] nArray = new int[2 * this.startIndexes.length];
            int[] nArray2 = new int[2 * this.pastIndexes.length];
            System.arraycopy(this.startIndexes, 0, nArray, 0, this.startIndexes.length);
            System.arraycopy(this.pastIndexes, 0, nArray2, 0, this.pastIndexes.length);
            this.startIndexes = nArray;
            this.pastIndexes = nArray2;
        }
        this.startIndexes[n] = n2;
        this.pastIndexes[n] = n3;
    }

    public void setNormalWrapCharacters(char[] cArray) {
        this.normalWrapCharacters = cArray;
    }

    public void setPersistentWrapCharacters(char[] cArray) {
        this.persistentWrapCharacters = cArray;
    }

    protected final void setUpBuffers(String string) {
        if (this.clearCounter++ % 1024 == 0) {
            this.startIndexes = new int[8];
            this.pastIndexes = new int[8];
            this.charBuf = new char[string.length()];
        }
        if (this.charBuf.length < string.length()) {
            this.charBuf = new char[string.length()];
        }
    }

    public void setWrapEnabled(boolean bl) {
        this.wrap = bl;
    }

    protected final void wrap(FontMetrics fontMetrics, char[] cArray, int n, int n2, int n3) {
        int n4;
        int n5;
        this.lineCount = 0;
        int n6 = n5 = this.nextStartIndex(cArray, n, n2);
        int n7 = n4 = this.nextWrapIndex(cArray, n5, n2);
        int n8 = 0;
        int n9 = fontMetrics.charsWidth(cArray, n5, n4 - n5);
        boolean bl = false;
        while (true) {
            if (n4 < n2 && n8 + n9 <= n3 && !bl) {
                n8 += n9;
                if (this.normalWrap) {
                    n8 += fontMetrics.charWidth(cArray[n4]);
                }
                n7 = n4;
                if (cArray[n4] == '\n') {
                    bl = true;
                }
                n5 = this.nextStartIndex(cArray, n4, n2);
                n4 = this.nextWrapIndex(cArray, n5, n2);
                n9 = fontMetrics.charsWidth(cArray, n5, n4 - n5);
                continue;
            }
            if (bl || n8 + n9 > n3) {
                bl = false;
                if (n8 == 0) {
                    this.setLineIndexes(this.lineCount++, n5, n4);
                    if (n4 >= n2) {
                        return;
                    }
                    n6 = n5 = this.nextStartIndex(cArray, n4, n2);
                    n7 = n4 = this.nextWrapIndex(cArray, n5, n2);
                } else {
                    this.setLineIndexes(this.lineCount++, n6, n7);
                    n6 = n5;
                    n7 = n4;
                }
                n8 = 0;
            }
            if (n4 >= n2) break;
        }
        this.setLineIndexes(this.lineCount++, n6, n2);
    }
}

