/*
 * Decompiled with CFR 0.152.
 */
package tstuder.java.lib.util;

import java.util.Vector;
import tstuder.java.lib.util.Sortable;
import tstuder.java.lib.util.SwapListener;

public class SortableVector
extends Vector {
    protected transient int[] indexes;
    private transient Sortable compare;
    private transient SwapListener swapListener;

    public SortableVector() {
    }

    public SortableVector(int n) {
        super(n);
    }

    public SortableVector(int n, int n2) {
        super(n, n2);
    }

    public void addSwapListener(SwapListener swapListener) {
        this.swapListener = swapListener;
    }

    public SwapListener getSwapListener() {
        return this.swapListener;
    }

    public final synchronized int linearIndexLookup(Sortable sortable) {
        int n = 0;
        while (n < this.size()) {
            if (sortable.compare(sortable, this.elementAt(n)) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public final synchronized int linearIndexLookup(Sortable sortable, int n) {
        int n2 = n;
        while (n2 < this.size()) {
            if (sortable.compare(sortable, this.elementAt(n2)) == 0) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public synchronized Object linearLookup(Sortable sortable) {
        int n = 0;
        while (n < this.size()) {
            if (sortable.compare(sortable, this.elementAt(n)) == 0) {
                return this.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    public synchronized int linearLookup(Sortable sortable, int n) {
        int n2 = n;
        while (n2 < this.size()) {
            if (sortable.compare(sortable, this.elementAt(n2)) == 0) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void sort(int n, int n2) {
        if (n >= n2) {
            return;
        }
        this.swap(n, (n + n2) / 2);
        int n3 = n;
        if (this.indexes == null) {
            int n4 = n + 1;
            while (n4 <= n2) {
                if (this.compare.compare(this.elementData[n], this.elementData[n4]) > 0) {
                    this.swap(++n3, n4);
                }
                ++n4;
            }
        } else {
            int n5 = n + 1;
            while (n5 <= n2) {
                if (this.compare.compare(this.elementData[this.indexes[n]], this.elementData[this.indexes[n5]]) > 0) {
                    this.swap(++n3, n5);
                }
                ++n5;
            }
        }
        this.swap(n, n3);
        this.sort(n, n3 - 1);
        this.sort(n3 + 1, n2);
    }

    public synchronized void sort(int n, int n2, Sortable sortable) {
        this.sort(n, n2, sortable, null);
    }

    public synchronized void sort(int n, int n2, Sortable sortable, int[] nArray) {
        this.compare = sortable;
        this.indexes = nArray;
        if (nArray != null) {
            int n3 = n;
            while (n3 <= n2) {
                nArray[n3] = n3;
                ++n3;
            }
        }
        this.sort(n, n2);
    }

    public synchronized void sort(Sortable sortable) {
        this.sort(0, this.size() - 1, sortable);
    }

    protected final void swap(int n, int n2) {
        if (this.indexes == null) {
            Object object = this.elementData[n];
            this.elementData[n] = this.elementData[n2];
            this.elementData[n2] = object;
        } else {
            int n3 = this.indexes[n];
            this.indexes[n] = this.indexes[n2];
            this.indexes[n2] = n3;
        }
        if (this.swapListener != null) {
            this.swapListener.swapped(n, n2);
        }
    }
}

